import { MesWarehouseStockModel, MesWarehouseStockPageParams, MesWarehouseStockPageResult } from './model/WhStockModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/whstock/page',
  List = '/mes/whstock/list',
  Info = '/mes/whstock/info',
  MesWarehouseStock = '/mes/whstock',
  
  
  Export = '/mes/whstock/export',
}

/**
 * @description: 查询MesWarehouseStock分页列表
 */
export async function getMesWarehouseStockPage(params: MesWarehouseStockPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseStockPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseStock信息
 */
export async function getMesWarehouseStock(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseStockModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseStock
 */
export async function addMesWarehouseStock(mesWarehouseStock: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseStock,
      params: mesWarehouseStock,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseStock
 */
export async function updateMesWarehouseStock(mesWarehouseStock: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseStock,
      params: mesWarehouseStock,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseStock（批量删除）
 */
export async function deleteMesWarehouseStock(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseStock,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseStock
 */
export async function exportMesWarehouseStock(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}