import {
  MesProOrderworkModel,
  MesProOrderworkPageParams,
  MesProOrderworkPageResult,
} from './model/ProOrderWorkModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proorderwork/page',
  List = '/mes/proorderwork/list',
  Info = '/mes/proorderwork/info',
  MesProOrderwork = '/mes/proorderwork',
}

/**
 * @description: 查询MesProOrderwork分页列表
 */
export async function getMesProOrderworkPage(
  params: MesProOrderworkPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProOrderworkPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrderwork信息
 */
export async function getMesProOrderwork(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderworkModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrderwork
 */
export async function addMesProOrderwork(
  mesProOrderwork: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrderwork,
      params: mesProOrderwork,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrderwork
 */
export async function updateMesProOrderwork(
  mesProOrderwork: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrderwork,
      params: mesProOrderwork,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrderwork（批量删除）
 */
export async function deleteMesProOrderwork(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrderwork,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
export async function updateMesProOrderworkState(
  id: string,
  state: string,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorderwork/updateState/' + id + '/' + state,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function updateMesProOrderworkList(
  mesProOrderwork: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorderwork/updateBatchPoint',
      params: mesProOrderwork,
    },
    {
      errorMessageMode: mode,
    },
  );
}
