import {
  MesBaseWarehousetypeModel,
  MesBaseWarehousetypePageParams,
  MesBaseWarehousetypePageResult,
} from './model/BaseWarehousetypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/basewarehousetype/page',
  List = '/mes/basewarehousetype/list',
  Info = '/mes/basewarehousetype/info',
  MesBaseWarehousetype = '/mes/basewarehousetype',

  Export = '/mes/basewarehousetype/export',
}

/**
 * @description: 查询MesBaseWarehousetype分页列表
 */
export async function getMesBaseWarehousetypePage(
  params: MesBaseWarehousetypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesBaseWarehousetypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseWarehousetype信息
 */
export async function getMesBaseWarehousetype(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseWarehousetypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseWarehousetype
 */
export async function addMesBaseWarehousetype(
  mesBaseWarehousetype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseWarehousetype,
      params: mesBaseWarehousetype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseWarehousetype
 */
export async function updateMesBaseWarehousetype(
  mesBaseWarehousetype: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseWarehousetype,
      params: mesBaseWarehousetype,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseWarehousetype（批量删除）
 */
export async function deleteMesBaseWarehousetype(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseWarehousetype,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesBaseWarehousetype
 */
export async function exportMesBaseWarehousetype(
  params?: object,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
