import { CommonInfoType } from '/@/components/Designer';
import { camelCaseString } from '/@/utils/event/design';

//查询为inputNumber的组件
const iptNumComponents = ['number', 'slider', 'rate', 'computational', 'money-chinese'];

const remoteComponents = [
  'select',
  'associate-select',
  'associate-popup',
  'multiple-popup',
  'checkbox',
  'radio',
];

export const handleSearchForm = (option, schema, item, isNeedTrans, convertCamel = true) => {
  if (!isNeedTrans) {
    return convertCamel
      ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'Input',
      },`
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: 'Input',
        };
  }
  if (iptNumComponents.includes(schema.type)) {
    return convertCamel
      ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
          defaultValue: ${item.fieldValue != undefined ? item!.fieldValue : undefined},
        component: 'InputNumber',
        componentProps:{
          style:{ width:'100%' }
        },
      },`
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: 'InputNumber',
          componentProps: {
            style: { width: '100%' },
          },
        };
  }
  if (remoteComponents.includes(schema.type)) {
    if (option && option?.datasourceType === 'staticData') {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'XjrSelect',
        componentProps: {  
          datasourceType:'staticData',
          staticOptions: ${JSON.stringify(option.staticOptions)},
          labelField: '${option.labelField}',
          valueField: '${option.valueField}',
          mode:'multiple',
          showSearch:true,
          getPopupContainer: () => document.body,
        },
      },`
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'XjrSelect',
            componentProps: {
              datasourceType: 'staticData',
              staticOptions: option.staticOptions,
              labelField: option.labelField,
              valueField: option.valueField,
              mode: 'multiple',
              showSearch: true,
              getPopupContainer: () => document.body,
            },
          };
    } else if (option && option?.datasourceType === 'dic') {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'XjrSelect',
        componentProps: {
          datasourceType:'dic',
          params: ${JSON.stringify(option.params)},
          labelField: '${option.labelField}',
          valueField: '${option.valueField}',
          mode:'multiple',
          showSearch: true,
          getPopupContainer: () => document.body,
        },
      },`
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'XjrSelect',
            componentProps: {
              datasourceType: 'dic',
              params: option.params,
              labelField: option.labelField,
              valueField: option.valueField,
              mode: 'multiple',
              showSearch: true,
              getPopupContainer: () => document.body,
            },
          };
    } else if (option && option?.datasourceType === 'api') {
      return convertCamel
        ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: 'XjrSelect',
      componentProps: {
        datasourceType:'api',
        apiConfig: ${JSON.stringify(option.apiConfig)},
        labelField: '${option.labelField}',
        valueField: '${option.valueField}',
        mode:'multiple',
        showSearch: true,
        getPopupContainer: () => document.body,
      },
    },`
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'XjrSelect',
            componentProps: {
              datasourceType: 'api',
              apiConfig: option.apiConfig,
              labelField: option.labelField,
              valueField: option.valueField,
              mode: 'multiple',
              showSearch: true,
              getPopupContainer: () => document.body,
            },
          };
    }
  }
  if (schema.type === 'switch') {
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item!.fieldValue == undefined ? 1 : Number(item!.fieldValue)},
      component: 'Select',
      componentProps:{
        getPopupContainer: () => document.body,
        options:[
          {
            label:'开',
            value: 1
          },{
            label:'关',
            value: 0
          }
        ]
      },
    },
    `
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue == undefined ? 1 : Number(item!.fieldValue),
          component: 'Select',
          componentProps: {
            options: [
              {
                label: '开',
                value: 1,
              },
              {
                label: '关',
                value: 0,
              },
            ],
          },
        };
  }
  if (schema.type === 'time') {
    let str: undefined | string = '';
    if (convertCamel) {
      if (item.fieldValue == undefined) {
        str = undefined;
      } else if (item!.fieldValue.includes(',')) {
        const val = item!.fieldValue.split(',');
        str = `['${val[0]}', '${val[1]}']`;
      }
    }
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
      defaultValue: ${str},
      component: '${option.searchType == 'time' ? 'TimeRangePicker' : 'TimeRangePicker'}',
      componentProps:{
        format:'${option.format}',
        style: { width: '100%' },
        getPopupContainer: () => document.body,
      },
    },`
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue:
            item.fieldValue != undefined
              ? item!.fieldValue.includes(',')
                ? item!.fieldValue.split(',')
                : undefined
              : undefined,
          component: option.searchType == 'time' ? 'TimeRangePicker' : 'TimeRangePicker',
          componentProps: {
            format: option.format,
            style: { width: '100%' },
            getPopupContainer: () => document.body,
          },
        };
  }
  if (schema.type === 'date') {
    let str: undefined | string = '';
    if (convertCamel) {
      if (item.fieldValue == undefined) {
        str = undefined;
      } else if (item!.fieldValue.includes(',')) {
        const val = item!.fieldValue.split(',');
        str = `['${val[0]}', '${val[1]}']`;
      }
    }
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
      defaultValue: ${str},
      component: '${option.searchType == 'time' ? 'RangePicker' : 'RangePicker'}',
      componentProps:{
        format:'${option.format}',
        style: { width: '100%' },
        getPopupContainer: () => document.body,
      },
    },
    `
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue:
            item.fieldValue != undefined
              ? item!.fieldValue.includes(',')
                ? item!.fieldValue.split(',')
                : undefined
              : undefined,
          component: option.searchType == 'time' ? 'RangePicker' : 'RangePicker',
          componentProps: {
            format: option.format,
            style: { width: '100%' },
            getPopupContainer: () => document.body,
          },
        };
  }
  if (schema.type === 'user' || schema.type === 'role') {
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: '${schema.type === 'user' ? 'User' : 'Role'}',
      componentProps:{
        suffix:'ant-design:setting-outlined',
        placeholder:'请选择'
      },
    },
    `
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: schema.type === 'user' ? 'User' : 'Role',
          componentProps: {
            suffix: 'ant-design:setting-outlined',
            placeholder: '请选择',
          },
        };
  }
  if (schema.type === 'tree-select-component') {
    const val = schema!.componentProps;
    val.defaultValue = '';
    return convertCamel
      ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: '${schema!.component}',
        componentProps: ${JSON.stringify(val)},
      },`
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: schema!.component,
          componentProps: schema!.componentProps,
        };
  }

  if (schema.type === 'area') {
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: 'Area',
      componentProps:{
        suffix:'ant-design:setting-outlined',
        placeholder:'请选择',
        getPopupContainer: () => document.body,
      },
    },
    `
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: 'Area',
          componentProps: {
            suffix: 'ant-design:setting-outlined',
            placeholder: '请选择',
            getPopupContainer: () => document.body,
          },
        };
  }
  if (schema.type === 'organization') {
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
     defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: '${schema!.component}',
      componentProps:{
        placeholder:'请选择',
        getPopupContainer: () => document.body,
      },
    },`
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: schema!.component,
          componentProps: {
            placeholder: '请选择',
            getPopupContainer: () => document.body,
          },
        };
  }
  if (schema.type === 'cascader') {
    return convertCamel
      ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: '${schema!.component}',
      componentProps: {
        apiConfig: ${JSON.stringify(option.apiConfig)},
        showFormat: '${option.showFormat}',
        separator: '${option.separator}',
        selectedConfig: 'any',
      },
    },
    `
      : {
          field: item.fieldName,
          label: schema!.label,
          defaultValue: item!.fieldValue,
          component: schema!.component,
          componentProps: {
            apiConfig: option.apiConfig,
            showFormat: option.showFormat,
            separator: option.separator,
            selectedConfig: 'any',
          },
        };
  }
  if (schema.type === 'info') {
    if (option && option.infoType === CommonInfoType.USER_NAME) {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
         defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'User',
        componentProps:{
          suffix:'ant-design:setting-outlined',
          placeholder:'请选择'
        },
      },
      `
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'User',
            componentProps: {
              suffix: 'ant-design:setting-outlined',
              placeholder: '请选择',
            },
          };
    } else if (
      (option && option.infoType === CommonInfoType.DEPT_NAME) ||
      option.infoType === CommonInfoType.DEPT_ID
    ) {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'Dept',
        componentProps:{
          placeholder:'请选择',
          getPopupContainer: () => document.body,
        },
      },
      `
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'Dept',
            componentProps: {
              placeholder: '请选择',
              getPopupContainer: () => document.body,
            },
          };
    } else if (option && option.infoType === CommonInfoType.TIME) {
      return convertCamel
        ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
      defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: 'DatePicker',
      componentProps:{
        format:'YYYY-MM-DD HH:mm:ss',
        style: { width: '100%' },
        getPopupContainer: () => document.body,
      },
    },
    `
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'DatePicker',
            componentProps: {
              format: 'YYYY-MM-DD HH:mm:ss',
              style: { width: '100%' },
              getPopupContainer: () => document.body,
            },
          };
    } else if (option && option.infoType === CommonInfoType.ROLE_NAME) {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'Role',
      },`
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'Role',
          };
    } else {
      return convertCamel
        ? `{
        field: '${camelCaseString(item.fieldName)}',
        label: '${schema!.label}',
        defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
        component: 'Input',
      },`
        : {
            field: item.fieldName,
            label: schema!.label,
            defaultValue: item!.fieldValue,
            component: 'Input',
          };
    }
  }
  return convertCamel
    ? `{
      field: '${camelCaseString(item.fieldName)}',
      label: '${schema!.label}',
       defaultValue: ${item.fieldValue != undefined ? `'` + item!.fieldValue + `'` : undefined},
      component: '${schema!.component}',
    },
    `
    : {
        field: item.fieldName,
        label: schema!.label,
        defaultValue: item!.fieldValue,
        component: schema!.component,
      };
};

export const handleAppSearchForm = (option, schema, item, isNeedTrans, convertCamel = true) => {
  if (!schema) return;
  const fieldName = convertCamel ? camelCaseString(item.fieldName) : item.fieldName;
  const field = `field: '${fieldName}',`;
  const params = `key: '${schema.key}',
      name: '${schema!.label}',
      label: '${schema!.label}',`;
  if (isNeedTrans) {
    if (schema.component == 'TimeRange') {
      if (option.searchType == 'time') {
        return `{
          ${params} 
          ${field}
          component: componentType.timeRange, //组件类型 
          componentProps: ${JSON.stringify(schema.componentProps)},  
        },`;
      } else {
        return `{
        ${params} 
        field: '${fieldName + 'Start,' + fieldName + 'End'}',
        component: componentType.timeRange, //组件类型
        startTimeField:'${fieldName + 'Start'}',
				endTimeField:'${fieldName + 'End'}',
        componentProps: { 
          startTimePlaceholder: '开始时间',
          endTimePlaceholder: '结束时间',
          isRange: true,
        }, //组件的所有配置信息
      },`;
      }
    } else if (schema.component == 'DateTime') {
      if (option.searchType == 'time') {
        return `{
          ${params} 
          ${field}
          component: componentType.dateTime, //组件类型 
          componentProps: ${JSON.stringify(schema.componentProps)},   
        },`;
      } else {
        return `{
          ${params}
          field: '${fieldName + 'Start,' + fieldName + 'End'}',
          component: componentType.dateRange, //组件类型
          startTimeField:'${fieldName + 'Start'}',
          endTimeField:'${fieldName + 'End'}',
          componentProps: {
            formatType:'${
              option.format == 'YYYY-MM'
                ? 'month'
                : option.format == 'YYYY'
                ? 'year'
                : option.format == 'YYYY-MM-DD HH:mm:ss'
                ? 'datetime'
                : 'date'
            }',
            type: "datetimerange", //日期时间范围选择器
            startPlaceholder: '开始日期',
            endPlaceholder: '结束日期',
          }, //组件的所有配置信息
        },`;
      }
    } else if (schema.component == 'Switch') {
      return `{
        ${params}
        ${field}
        component: componentType.select, //组件类型  
        componentProps: { 
          localdata:[{text:'开',value:1},{text:'关',value:0}], 
        },  
      },`;
    } else if (
      schema.component == 'Checkbox' ||
      schema.component == 'Radio' ||
      schema.component == 'Select'
    ) {
      return `{
        ${params}
        ${field}
        component: componentType.select, //组件类型
        componentProps: ${JSON.stringify(schema.componentProps)},
      },`;
    } else if (schema.component == 'TreeSelect') {
      return `{
        ${params}
        ${field}
        component: componentType.TreeSelect, //组件类型
        componentProps:  ${JSON.stringify(schema.componentProps)},
      },`;
    } else if (schema.component == 'colorPicker') {
      return `{
        ${params}
        ${field}
        component: componentType.color, //组件类型 
        defaultValue:null,
        componentProps: {},  
      },`;
    } else if (schema.component == 'InputNumber') {
      return `{
        ${params}
        ${field}
        component: componentType.input, //组件类型
        componentProps: {
          type: 'number',
        },
      },`;
    } else if (schema.component == 'Role') {
      return `{
          ${params}
          ${field}
          component: componentType.role, //组件类型
          componentProps: {
            placeholder: '请选择角色',
            suffixIcon: 'ant-design:setting-outlined',
          },
        },`;
    } else if (schema.component == 'Info' || schema.component == 'User') {
      if (
        schema.componentProps.infoType === CommonInfoType.USER_NAME ||
        schema.component == 'User'
      ) {
        return `{
          ${params}
          ${field}
          component: componentType.user, //组件类型
          componentProps: {
            placeholder: '请选择人员',
            suffixIcon: 'ant-design:setting-outlined',
          },
        },`;
      } else if (
        schema.componentProps.infoType === CommonInfoType.DEPT_NAME ||
        schema.componentProps.infoType === CommonInfoType.DEPT_ID
      ) {
        return `{
          ${params}
          ${field}
          component: componentType.organization, //组件类型
          componentProps: {
            placeholder: '请选择组织架构',
          },
        },`;
      } else if (schema.componentProps.infoType === CommonInfoType.TIME) {
        return `{
          ${params}
          field: '${fieldName + 'Start,' + fieldName + 'End'}',
          component: componentType.dateRange, //组件类型
          startTimeField:'${fieldName + 'Start'}',
				  endTimeField:'${fieldName + 'End'}',
          componentProps: {
            formatType: 'datetime',
            type: 'datetimerange', //日期时间范围选择器
            startPlaceholder: '开始日期',
            endPlaceholder: '结束日期',
          },
        },`;
      } else if (schema.componentProps.infoType === CommonInfoType.ROLE_NAME) {
        return `{
        ${params}
        ${field}
        component: componentType.role, //组件类型
        componentProps: {
          placeholder: '请输入${schema.label}',
          disabled:false
        },
      },`;
      } else {
        return `{
        ${params}
        ${field}
        component: componentType.input, //组件类型
        componentProps: {
          placeholder: '请输入${schema.label}',
          disabled:false
        },
      },`;
      }
    } else {
      return JSON.stringify(schema) + ',';
    }
  } else {
    return `{
      ${params}
      ${field}
      component: componentType.input, //组件类型
      componentProps: { 
        placeholder: '请输入${schema.label}',
      }
    },`;
  }
};
