
import { RokeUomPageModel, RokeUomPageParams, RokeUomPageResult } from './model/JldwModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/jldw/page',
  List = '/jcsj/jldw/list',
  Info = '/jcsj/jldw/info',
  RokeUom = '/jcsj/jldw',
  
  
  
}

/**
 * @description: 查询RokeUom分页列表
 */
export async function getRokeUomPage(params: RokeUomPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeUomPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeUom信息
 */
export async function getRokeUom(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeUomPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeUom
 */
export async function addRokeUom(rokeUom: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeUom,
      params: rokeUom,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeUom
 */
export async function updateRokeUom(rokeUom: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeUom,
      params: rokeUom,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeUom（批量删除）
 */
export async function deleteRokeUom(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeUom,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




