import { Table52930Model, Table52930PageParams, Table52930PageResult } from './model/AaaaModel';
import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/bi/aaaa/page',
  List = '/bi/aaaa/list',
  Info = '/bi/aaaa/info',
  Table52930 = '/bi/aaaa',
}

/**
 * @description: 查询Table52930分页列表
 */
export async function getTable52930Page(
  params: Table52930PageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<Table52930PageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取Table52930信息
 */
export async function getTable52930(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<Table52930Model>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增Table52930
 */
export async function addTable52930(table52930: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.Table52930,
      params: table52930,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新Table52930
 */
export async function updateTable52930(table52930: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.Table52930,
      params: table52930,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除Table52930（批量删除）
 */
export async function deleteTable52930(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.Table52930,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
