import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseStock分页参数 模型
 */
export interface MesWarehouseStockPageParams extends BasicPageParams {
  productNo: string;

  productName: string;

  warehouseId: string;

  areaId: string;

  locationId: string;

  deType: string;
}

/**
 * @description: MesWarehouseStock分页返回值模型
 */
export interface MesWarehouseStockPageModel {
  id: string;

  productNo: string;

  productName: string;

  deType: string;

  unity: string;

  warehouseId: string;

  areaId: string;

  locationId: string;

  num: string;
}

/**
 * @description: MesWarehouseStock表类型
 */
export interface MesWarehouseStockModel {
  id: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  deType: string;

  unity: string;

  warehouseId: string;

  areaId: string;

  locationId: string;

  num: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseStock分页返回值结构
 */
export type MesWarehouseStockPageResult = BasicFetchResult<MesWarehouseStockPageModel>;