import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQbFinishError分页参数 模型
 */
export interface MesQbFinishErrorPageParams extends BasicPageParams {
  errorNo: string;

  errorLevel: string;

  errorState: string;

  reportNo: string;

  reportName: string;

  disJudge: string;

  judgeResult: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;

  remark: string;
}

/**
 * @description: MesQbFinishError分页返回值模型
 */
export interface MesQbFinishErrorPageModel {
  id: string;

  errorNo: string;

  errorLevel: string;

  reportNo: string;

  reportName: string;

  disJudge: string;

  judgeResult: string;

  createUserId: string;

  createDate: string;

  errorState: string;

  remark: string;
}

/**
 * @description: MesQbFinishError表类型
 */
export interface MesQbFinishErrorModel {
  id: number;

  isSysNum: string;

  reportId: string;

  reportNo: string;

  reportName: string;

  errorNo: string;

  errorLevel: string;

  disJudge: string;

  judgeResult: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQbFinishErrorDetailList?: MesQbFinishErrorDetailModel;
}

/**
 * @description: MesQbFinishErrorDetail表类型
 */
export interface MesQbFinishErrorDetailModel {
  id: number;

  errorId: number;

  reportId: number;

  reportNo: string;

  reportName: string;

  workNo: string;

  saleId: string;

  saleNo: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  carId: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  errorNum: string;

  errorMethod: string;

  imgFile: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQbFinishError分页返回值结构
 */
export type MesQbFinishErrorPageResult = BasicFetchResult<MesQbFinishErrorPageModel>;
