import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'djrq',
    label: '单据日期',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'clr',
    label: '处理人',
    defaultValue: undefined,
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
  },

  {
    field: 'sszz',
    label: '所属组织',
    defaultValue: undefined,
    component: 'Dept',
    componentProps: {
      placeholder: '请选择',
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'djbh',
    title: '单据编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'djrq',
    title: '单据日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clr',
    title: '处理人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'modifyDate',
    title: '处理日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'createDate',
    title: '创建日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'sszz',
    title: '所属组织',
    componentType: 'organization',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '43514ab9ca2849e0a15b47508a26affb',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'f5a618c2a6a94e26b4db4b5d6820f342',
              field: 'djbh',
              label: '单据编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 4,
                placeholder: '自动生成编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'BHGPCL',
                required: true,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '13c73d2d8d71455cb0be06371bbdaddd',
              field: 'djrq',
              label: '单据日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择单据日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'de9efe3a5f734b6bb6ede5fc6e5c23c9',
              field: 'clr',
              label: '处理人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                width: '100%',
                defaultValue: '',
                placeholder: '请选择处理人',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:usergroup-add-outlined',
                showLabel: true,
                disabled: false,
                required: true,
                multiple: true,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '226c633a8ed645c7874663c603ac68f5',
              field: 'modifyDate',
              label: '处理日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择处理日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '47e825566c424771bdb773c64173ea76',
              field: 'createDate',
              label: '创建日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 4,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择创建日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: false,
                disabled: true,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'b961eae9a32b4e9e872950f1b178fbfb',
              field: 'sszz',
              label: '所属组织',
              type: 'organization',
              component: 'Dept',
              colProps: { span: 24 },
              componentProps: {
                span: 4,
                width: '100%',
                orgzType: 0,
                placeholder: '请选择所属组织',
                isShowAllName: false,
                showLabel: true,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 24,
          list: [
            {
              key: '61888c9b5fd64d41b09ae2b012949d81',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 1,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '213924f5313b4d45a8b4f750d43153d7',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '质检明细',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '87cc5a35158547959a7b529ab5ff1eb1',
              label: '',
              field: 'mesQualityUnqualifiedRelaList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesQualityUnqualifiedRelaList',
                columns: [
                  {
                    key: 'e613548f2de84a17b4bca54b2bfa5e5a',
                    title: '单据编号',
                    dataIndex: 'djbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入单据编号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: true,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '44de1157b89d42d5a26acd3e3e380e13',
                    title: '单据日期',
                    dataIndex: 'djrq',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '请选择单据日期',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: true,
                      disabled: false,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                    },
                  },
                  {
                    key: '80339f4ee04e4eb486b2bd02c5df14d6',
                    title: '物料编号',
                    dataIndex: 'wlbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入物料编号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '52bbeea35e75496094f2b4139bdd5a6f',
                    title: '物料名称',
                    dataIndex: 'wlmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入物料名称',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'cf4ba5d21db146128a1470633424e465',
                    title: '炉批号',
                    dataIndex: 'lph',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入炉批号',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '61926e5bff6944578afe5ca68f45495a',
                    title: '检验标准',
                    dataIndex: 'jybz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入检验标准',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'c231765d287d47c689fa1a979de36588',
                    title: '送检数量',
                    dataIndex: 'sjsl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '68691f5b06bb4c2cb6e3a14a4758100a',
                    title: '检查数量',
                    dataIndex: 'jcsl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '559986b7045641a48266913776aa0ac3',
                    title: '质检人',
                    dataIndex: 'zjr',
                    componentType: 'User',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      width: '100%',
                      defaultValue: '',
                      placeholder: '请选择质检人',
                      userType: 0,
                      prefix: '',
                      suffix: 'ant-design:user-outlined',
                      showLabel: true,
                      disabled: false,
                      required: false,
                      multiple: true,
                      isShow: true,
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '2b8bac1dae81498880e7df1f9df863b1',
                    title: '质检状态',
                    dataIndex: 'zjzt',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '请选择质检状态',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: null,
                      datasourceType: 'dic',
                      params: { itemId: '2010885273788829698' },
                      labelField: 'name',
                      valueField: 'value',
                      apiConfig: {
                        path: 'CodeGeneration/selection',
                        method: 'GET',
                        apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      itemId: '2010885273788829698',
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '448db681d3b94fae8172be46e297b512',
                    title: '不合格数',
                    dataIndex: 'bhgs',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'd2bd69bdf1664619849c2752445622d1',
                    title: '不合格原因',
                    dataIndex: 'bhgyy',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入不合格原因',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'df7880cff284461885fa5a4afe31a43d',
                    title: '处理方式',
                    dataIndex: 'clfs',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入处理方式',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '214a1a0deb4e41d1adeb348f67192f66',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入备注',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: true,
                viewList: [
                  {
                    key: 'e613548f2de84a17b4bca54b2bfa5e5a',
                    label: '单据编号',
                    field: 'djbh',
                    componentType: 'input',
                    checked: false,
                  },
                  {
                    key: '44de1157b89d42d5a26acd3e3e380e13',
                    label: '单据日期',
                    field: 'djrq',
                    componentType: 'date',
                    checked: false,
                  },
                  {
                    key: '80339f4ee04e4eb486b2bd02c5df14d6',
                    label: '物料编号',
                    field: 'wlbh',
                    componentType: 'input',
                    checked: false,
                  },
                  {
                    key: '52bbeea35e75496094f2b4139bdd5a6f',
                    label: '物料名称',
                    field: 'wlmc',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: 'cf4ba5d21db146128a1470633424e465',
                    label: '炉批号',
                    field: 'lph',
                    componentType: 'input',
                    checked: true,
                  },
                  {
                    key: '61926e5bff6944578afe5ca68f45495a',
                    label: '检验标准',
                    field: 'jybz',
                    componentType: 'input',
                    checked: false,
                  },
                  {
                    key: 'c231765d287d47c689fa1a979de36588',
                    label: '送检数量',
                    field: 'sjsl',
                    componentType: 'number',
                    checked: true,
                  },
                  {
                    key: '68691f5b06bb4c2cb6e3a14a4758100a',
                    label: '检查数量',
                    field: 'jcsl',
                    componentType: 'number',
                    checked: true,
                  },
                  {
                    key: '559986b7045641a48266913776aa0ac3',
                    label: '质检人',
                    field: 'zjr',
                    componentType: 'user',
                    checked: false,
                  },
                  {
                    key: '2b8bac1dae81498880e7df1f9df863b1',
                    label: '质检状态',
                    field: 'zjzt',
                    componentType: 'select',
                    checked: true,
                  },
                  {
                    key: '448db681d3b94fae8172be46e297b512',
                    label: '不合格数',
                    field: 'bhgs',
                    componentType: 'number',
                    checked: true,
                  },
                  {
                    key: 'd2bd69bdf1664619849c2752445622d1',
                    label: '不合格原因',
                    field: 'bhgyy',
                    componentType: 'input',
                    checked: false,
                  },
                  {
                    key: 'df7880cff284461885fa5a4afe31a43d',
                    label: '处理方式',
                    field: 'clfs',
                    componentType: 'input',
                    checked: false,
                  },
                  {
                    key: '214a1a0deb4e41d1adeb348f67192f66',
                    label: '备注',
                    field: 'bz',
                    componentType: 'input',
                    checked: false,
                  },
                ],
                isShowAdd: false,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'card', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
