import {
  MesProOrderplanModel,
  MesProOrderplanPageParams,
  MesProOrderplanPageResult,
} from './model/ProOrderPlanModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proorderplan/page',
  List = '/mes/proorderplan/list',
  Info = '/mes/proorderplan/info',
  MesProOrderplan = '/mes/proorderplan',
}

/**
 * @description: 查询MesProOrderplan分页列表
 */
export async function getMesProOrderplanPage(
  params: MesProOrderplanPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProOrderplanPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrderplan信息
 */
export async function getMesProOrderplan(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderplanModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrderplan
 */
export async function addMesProOrderplan(
  mesProOrderplan: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrderplan,
      params: mesProOrderplan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrderplan
 */
export async function updateMesProOrderplan(
  mesProOrderplan: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrderplan,
      params: mesProOrderplan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrderplan（批量删除）
 */
export async function deleteMesProOrderplan(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrderplan,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function cancelMesProOrderPlan(
  ids: string[],
  rmk: string,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorderplan/cancel',
      params: { ids: ids, rmk: rmk },
    },
    {
      errorMessageMode: mode,
    },
  );
}
