import { MesQpProcessFirstModel, MesQpProcessFirstPageParams, MesQpProcessFirstPageResult } from './model/MesProcessFirstModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesprocessfirst/page',
  List = '/mes/mesprocessfirst/list',
  Info = '/mes/mesprocessfirst/info',
  MesQpProcessFirst = '/mes/mesprocessfirst',
  
  
}

/**
 * @description: 查询MesQpProcessFirst分页列表
 */
export async function getMesQpProcessFirstPage(params: MesQpProcessFirstPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessFirstPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQpProcessFirst信息
 */
export async function getMesQpProcessFirst(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessFirstModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQpProcessFirst
 */
export async function addMesQpProcessFirst(mesQpProcessFirst: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQpProcessFirst,
      params: mesQpProcessFirst,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQpProcessFirst
 */
export async function updateMesQpProcessFirst(mesQpProcessFirst: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQpProcessFirst,
      params: mesQpProcessFirst,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQpProcessFirst（批量删除）
 */
export async function deleteMesQpProcessFirst(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQpProcessFirst,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}