import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '待维修', value: '1' },
        { key: 2, label: '维修中', value: '2' },
        { key: 3, label: '已维修', value: '3' },
        { key: 4, label: '已报损', value: '4' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorTime',
    label: '故障时间',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'repairCode',
    label: '维修单编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'devCode',
    label: '设备编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'devName',
    label: '设备名称',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getDevList',
        method: 'GET',
        apiId: 'copy1690854319515d98152',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'dev_name',
                value: '',
                description: null,
                required: false,
                dataType: null,
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(dev_name!=null&&dev_name!=""){ \r\n    condition+=" and dev_name like \'%#{setup_type}%\'";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(dev_code,\'-\',dev_name) AS label,id,dev_code,dev_name,dev_type,dev_manage,dev_phone FROM mes_dev where state=1 "+condition)',
        outputParams: [
          { name: 'id', tableTitle: 'ID', bindField: 'dev_id', show: true, width: 150 },
          { name: 'id', tableTitle: 'ID', bindField: 'dev_id', show: true, width: 150 },
          { name: 'dev_no', tableTitle: '设备编码', bindField: 'dev_code', show: true, width: 150 },
          { name: 'id', tableTitle: 'ID', bindField: 'dev_id', show: false, width: 150 },
          {
            name: 'dev_code',
            tableTitle: '设备编码',
            bindField: 'dev_code',
            show: true,
            width: 150,
          },
          {
            name: 'dev_type',
            tableTitle: '设备类型',
            bindField: 'dev_type',
            show: false,
            width: 150,
          },
          {
            name: 'dev_code',
            tableTitle: '设备编码',
            bindField: 'dev_code',
            show: true,
            width: 150,
          },
          {
            name: 'dev_name',
            tableTitle: '设备名称',
            bindField: 'dev_name',
            show: true,
            width: 150,
          },
          {
            name: 'dev_type_name',
            tableTitle: '设备类型',
            bindField: '',
            show: true,
            width: 150,
          },
          {
            name: 'dev_manage',
            tableTitle: '负责人',
            bindField: 'dev_manage',
            show: true,
            width: 150,
          },
          {
            name: 'dev_phone',
            tableTitle: '联系方式',
            bindField: 'dev_phone',
            show: true,
            width: 150,
          },
        ],
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'devType',
    label: '设备类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getDevtypeList',
        method: 'GET',
        apiId: 'copy1690511011986d22891',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'repairCode',
    title: '维修单编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'devCode',
    title: '设备编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'devName',
    title: '设备名称',
    componentType: 'associate-popup',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'select',
    slots: { customRender: 'state' },
    sorter: true,
  },

  {
    dataIndex: 'devManage',
    title: '负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'errorTime',
    title: '故障时间',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'errorRemark',
    title: '故障原因',
    componentType: 'textarea',

    // customRender: ({ record }) => {
    //   const staticOptions = [
    //     { key: 1, label: '请选择', value: '' },
    //     { key: 2, label: '普通', value: '1' },
    //     { key: 3, label: '高级', value: '2' },
    //     { key: 4, label: '紧急', value: '3' },
    //   ];
    //   return staticOptions.filter((x) => x.value === record.errorRemark)[0].label;
    // },
    sorter: true,
  },

  {
    dataIndex: 'repairRemark',
    title: '维修描述',
    componentType: 'textarea',

    // customRender: ({ record }) => {
    //   const staticOptions = [
    //     { key: 1, label: '待维修', value: '1' },
    //     { key: 2, label: '维修中', value: '2' },
    //     { key: 3, label: '已维修', value: '3' },
    //     { key: 4, label: '已报损', value: '4' },
    //   ];
    //   return staticOptions.filter((x) => x.value === record.repairRemark)[0].label;
    // },
    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { span: 3, offset: 0 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'dee30b2dcda04598abf59998446bee38',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 16,
        style: {},
      },
    },

    {
      key: '9928acab4da7477ebfe65ebd6fd7cf56',
      field: 'repairCode',
      label: '维修单编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请输入维修单编码',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesrepairNo',
        required: true,
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='repairCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        style: {},
      },
    },
    {
      key: 'b6e45ce690e240b5a002ff74436a47ef',
      field: 'devName',
      label: '设备名称',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      componentProps: {
        popupType: 'associate',
        width: '100%',
        span: '',
        placeholder: '请选择设备名称',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getDevList',
          method: 'GET',
          apiId: 'copy1690854319515d98152',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: '',
                  description: null,
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(dev_name!=null&&dev_name!=""){ \r\n    condition+=" and dev_name like \'%#{setup_type}%\'";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(dev_code,\'-\',dev_name) AS label,id,dev_code,dev_name,dev_type,dev_manage,dev_phone FROM mes_dev where state=1 "+condition)',
          outputParams: [
            { name: 'id', tableTitle: 'ID', bindField: 'dev_id', show: false, width: 150 },
            {
              name: 'dev_type',
              tableTitle: '设备类型',
              bindField: 'dev_type',
              show: false,
              width: 150,
            },
            {
              name: 'dev_code',
              tableTitle: '设备编码',
              bindField: 'dev_code',
              show: true,
              width: 150,
            },
            {
              name: 'dev_name',
              tableTitle: '设备名称',
              bindField: 'dev_name',
              show: true,
              width: 150,
            },
            {
              name: 'dev_type_name',
              tableTitle: '设备类型',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'dev_manage',
              tableTitle: '负责人',
              bindField: 'dev_manage',
              show: true,
              width: 150,
            },
            {
              name: 'dev_phone',
              tableTitle: '联系方式',
              bindField: 'dev_phone',
              show: true,
              width: 150,
            },
            {
              name: 'dev_file2',
              tableTitle: '附件',
              bindField: 'error_file2',
              show: false,
              width: 150,
            },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '8bb3d65d79ea406f9370bbf89a695e8d',
      field: 'devCode',
      label: '设备编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入设备编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '7b094d55dd384dae884ea5e0187c9731',
      field: 'devType',
      label: '设备类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getDevtypeList',
          method: 'GET',
          apiId: 'copy1690511011986d22891',
          apiParams: [
            { key: '1', title: 'Query Params', tableInfo: [] },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(type_code,\'-\',type_name) AS label FROM mes_dev_type where state=1 "+condition)',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'fde21be519304d399b1b340e03e374bd',
      field: 'devManage',
      label: '负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '负责人请选择人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: true,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1eebbab9a3a346cf9b9585a53c089e53',
      field: 'devPhone',
      label: '联系方式',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入联系方式',
        maxlength: 100,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'd96ed6c47fbb4697b6f91b41351cec3c',
      field: 'errorTime',
      label: '故障时间',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择故障时间',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'd80cbed83caa43ffa51a76d26fd277e8',
      field: 'urgency',
      label: '紧急程度',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '请选择', value: '' },
          { key: 2, label: '普通', value: '1' },
          { key: 3, label: '高级', value: '2' },
          { key: 4, label: '紧急', value: '3' },
        ],
        defaultSelect: '',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '59080fb900a842408c4aed6fa640c6d3',
      field: 'state',
      label: '维修状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: true,
        staticOptions: [
          { key: 1, label: '待维修', value: '1' },
          { key: 2, label: '维修中', value: '2' },
          { key: 3, label: '已维修', value: '3' },
          { key: 4, label: '已报损', value: '4' },
        ],
        defaultSelect: '1',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '4abf89d5a2e7435b89a6903ba09f7a71',
      field: 'errorRemark',
      label: '故障原因',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 200,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'a45259d27cb44fa6bf79c1a0f1f8c06d',
      field: 'errorFile',
      label: '故障图片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: [],
        accept: '.jpg,.png',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
        listType: 'picture-card',
      },
    },
    {
      key: '68a41f233e3145bd9eb908bba3d17cb1',
      field: 'devId',
      label: '设备ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      ifShow: false,
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入设备ID',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },

    // {
    //   key: '3098dc8ce82c435cbb8d6dcb8240f285',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 0,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '81dd57047c3043718e3e79e7c19aa2d0',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     span: '',
    //     width: '100%',
    //     placeholder: '',
    //     infoType: 2,
    //     loadAgain: false,
    //     showLabel: true,
    //     disabled: true,
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '9290bd42a9954ef2a4f3a71310fb647d',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      defaultValue: '附件',
      componentProps: {
        defaultValue: '附件',
        color: '',
        align: 'left',
        fontSize: 16,
        style: {},
      },
    },
    {
      key: 'd9ad036835e949038839b5a7347a8627',
      field: 'errorFile2',
      label: '附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: '#{upload}#',
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: false,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
        listType: 'picture-card',
      },
    },
    // {
    //   key: 'db65d35e31c94f8da964e9c7c2780c2b',
    //   field: '',
    //   label: '',
    //   type: 'card',
    //   colProps: { span: 24 },
    //   component: 'Card',
    //   children: [
    //     {
    //       span: 24,
    //       name: 'card',
    //       list: [
    //         {
    //           key: '7114564d70f0483bb4f9dfd3a2947265',
    //           field: 'repairDate',
    //           label: '维修日期',
    //           type: 'date',
    //           component: 'DatePicker',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             span: '',
    //             defaultValue: '',
    //             width: '100%',
    //             placeholder: '请选择维修日期',
    //             format: 'YYYY-MM-DD',
    //             showLabel: true,
    //             allowClear: true,
    //             disabled: false,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '50d5e7f0a6824324b636aecb8b0f5624',
    //           field: 'repairStarttime',
    //           label: '开始时间',
    //           type: 'time',
    //           component: 'TimePicker',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             span: '',
    //             defaultValue: '',
    //             width: '100%',
    //             placeholder: '请选择开始时间',
    //             format: 'HH:mm:ss',
    //             showLabel: true,
    //             allowClear: true,
    //             disabled: false,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '9b2f698789fd43d9a7df193c58bb3731',
    //           field: 'repairEndtime',
    //           label: '结束时间',
    //           type: 'time',
    //           component: 'TimePicker',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             span: '',
    //             defaultValue: '',
    //             width: '100%',
    //             placeholder: '请选择结束时间',
    //             format: 'HH:mm:ss',
    //             showLabel: true,
    //             allowClear: true,
    //             disabled: false,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '0a9f461e4eca4fa0bcf9d9bd828f20fc',
    //           field: 'repairDuration',
    //           label: '维修时长',
    //           type: 'input',
    //           component: 'Input',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             width: '100%',
    //             span: '',
    //             defaultValue: '',
    //             placeholder: '请输入维修时长',
    //             maxlength: null,
    //             prefix: '',
    //             suffix: '',
    //             addonBefore: '',
    //             addonAfter: '',
    //             disabled: true,
    //             allowClear: false,
    //             showLabel: true,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '740bdea80c3a46a68ce12a5b30fa1b46',
    //           field: 'repairUser',
    //           label: '维修人',
    //           type: 'user',
    //           component: 'User',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             span: '',
    //             width: '100%',
    //             defaultValue: '',
    //             placeholder: '请选择人员',
    //             userType: 0,
    //             prefix: '',
    //             suffix: 'ant-design:setting-outlined',
    //             showLabel: true,
    //             disabled: false,
    //             required: true,
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '5224b2430e7a44e2a722334933005bae',
    //           field: 'repairErrorRmk',
    //           label: '故障描述',
    //           type: 'textarea',
    //           component: 'InputTextArea',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             width: '100%',
    //             span: '',
    //             defaultValue: '',
    //             placeholder: '请输入故障描述',
    //             maxlength: null,
    //             rows: 4,
    //             autoSize: false,
    //             showCount: false,
    //             disabled: false,
    //             showLabel: true,
    //             allowClear: false,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: '1d48e146187c40c8ac46987ee631bc38',
    //           field: 'repairRemark',
    //           label: '维修描述',
    //           type: 'textarea',
    //           component: 'InputTextArea',
    //           colProps: { span: 24 },
    //           defaultValue: '',
    //           componentProps: {
    //             width: '100%',
    //             span: '',
    //             defaultValue: '',
    //             placeholder: '请输入维修描述',
    //             maxlength: null,
    //             rows: 4,
    //             autoSize: false,
    //             showCount: false,
    //             disabled: false,
    //             showLabel: true,
    //             allowClear: false,
    //             required: false,
    //             rules: [],
    //             events: {},
    //             style: { width: '100%' },
    //           },
    //         },
    //         {
    //           key: 'eeb2a41ae8de4c94a9bf978c80e1e801',
    //           field: 'repairFile',
    //           label: '维修图片',
    //           type: 'upload',
    //           component: 'Upload',
    //           colProps: { span: 24 },
    //           componentProps: {
    //             api: '#{upload}#',
    //             span: '',
    //             defaultValue: [],
    //             accept: '.jpg,.png',
    //             maxNumber: 5,
    //             maxSize: 5,
    //             showLabel: true,
    //             multiple: false,
    //             disabled: false,
    //             required: false,
    //             events: {},
    //           },
    //         },
    //       ],
    //     },
    //   ],
    //   componentProps: { title: '维修信息' },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
