import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'sbmc',
    label: '设备名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'sbbm',
    label: '设备编码',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'sbmc',
    title: '设备名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'sbbm',
    title: '设备编码',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'sblx',
    title: '设备类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'sbzt',
    title: '设备状态',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'ggxh',
    title: '规格型号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'xcjyrq',
    title: '下次检验日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '1780e17da2da4e7d8807091bab1b4bb1',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: 'b20b170860d448e0b05118d3d8f2f73d',
              field: 'sbmc',
              label: '设备名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入设备名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '993427fdfa9e430483ea088ce9735472',
              field: 'sbbm',
              label: '设备编码',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入设备编码',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'e9da0ec0de7b40cc87a8d2e317b11f76',
              field: 'sblx',
              label: '设备类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 9,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx//cjcx/getEquipmentType',
                  method: 'GET',
                  apiId: 'cd65b71f0c124581b331f52db2f9566b',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select lxid as value,lxmc as label from mes_equipment_dict where delete_mark = 0 and lxbm = \'type\' and zt = 1";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '9ea9a3717ee842c5a1f465f95d2aa716',
              field: 'sbzt',
              label: '设备状态',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 9,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx//cjcx/getEquipmentStatus',
                  method: 'GET',
                  apiId: '265de6946ca24f5588374a54ac3c6484',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select lxid as value,lxmc as label from mes_equipment_dict where delete_mark = 0 and lxbm = \'status\' and zt = 1";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6ac08c6440ea4504931aa787b30854a7',
              field: 'fzr',
              label: '负责人',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 9,
                placeholder: '请选择负责人',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '2',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '66d22eb52be845319c4a039e4b79d3dd',
              field: 'gs',
              label: '公司',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 9,
                placeholder: '请选择公司',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '321a925f0949407c852d233d37dbe182',
              field: 'ggxh',
              label: '规格型号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入规格型号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '48ea92df4cd3461bb50657809b97f57c',
              field: 'zjbm',
              label: '整机编码',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入整机编码',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '4ca3e508868349638680ac36da7cd203',
              field: 'cj',
              label: '厂家',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入厂家',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'a43345e2552142cc90212c82711fe638',
              field: 'ccbh',
              label: '出厂编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入出厂编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '7635c9dadf1a4dfa8e842199e1ba8718',
              field: 'zcdm',
              label: '注册代码',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入注册代码',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '9262f92514f54819867bab30f11b2f1d',
              field: 'syz',
              label: '使用证编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 9,
                defaultValue: '',
                placeholder: '请输入使用证编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '9e5d3c135660400fbc200f82ace8b11b',
              field: 'bxqrq',
              label: '保修期日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 9,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择保修期日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6a8e757af4904dd0893520dbc4d01ac1',
              field: 'bcjyrq',
              label: '本次检验日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 10,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择本次检验日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '9065fd2f539e4db69719607a01ff162b',
              field: 'xcjyrq',
              label: '下次检验日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 10,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择下次检验日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 24,
          list: [
            {
              key: 'af6639b5cdee4960aea69ab38a68f285',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 2,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '0ce055c5a49546c79a96dd5cd03a2578',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '附属设备信息',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '8594e1ce231a4ca4867cdd37805f7ace',
              label: '',
              field: 'mesEquipmentFileInfoItemList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesEquipmentFileInfoItemList',
                columns: [
                  {
                    key: '59bb5c96f9e443d4b684f3be1a428256',
                    title: '选择设备',
                    dataIndex: 'sbmc',
                    componentType: 'MultiplePopup',
                    componentProps: {
                      popupType: 'associate',
                      width: '100%',
                      span: '',
                      placeholder: '请选择设备选择',
                      showLabel: true,
                      disabled: false,
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      pageSize: 10,
                      assoTitle: '联想弹层-联想数据配置',
                      apiConfig: {
                        path: '/jcxx//cjcx/getAllEquipment',
                        method: 'GET',
                        apiId: '61a02cba73cb4235a8a0b0a6ed5f31bb',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select id as value,sbmc as label from mes_equipment_file_info where delete_mark = 0";\r\nreturn db.select(sql);',
                        outputParams: [
                          {
                            name: 'sbbm',
                            tableTitle: '设备编码',
                            bindField: 'sbbm',
                            show: true,
                            width: 150,
                            component: '485d23d40fdd4686b3305787d1938c17',
                            bindTable: 'mes_equipment_file_info_item',
                          },
                          {
                            name: 'sblx',
                            tableTitle: '设备类型',
                            bindField: 'sblx',
                            show: true,
                            width: 150,
                            component: '9637a074c0714669b9ed548f9b3c56b7',
                            bindTable: 'mes_equipment_file_info_item',
                          },
                          {
                            name: 'sbzt',
                            tableTitle: '设备状态',
                            bindField: 'sbzt',
                            show: true,
                            width: 150,
                            component: '661a0cf626084e3bac8e7f04f9350050',
                            bindTable: 'mes_equipment_file_info_item',
                          },
                          {
                            name: 'ggxh',
                            tableTitle: '规格型号',
                            bindField: 'ggxh',
                            show: true,
                            width: 150,
                            component: '8eab0f870d2f44a3a4b96d9e3a48813b',
                            bindTable: 'mes_equipment_file_info_item',
                          },
                          {
                            name: 'cj',
                            tableTitle: '厂家',
                            bindField: 'cj',
                            show: true,
                            width: 150,
                            component: '40d7c05f9998488084e250d6d274f6f0',
                            bindTable: 'mes_equipment_file_info_item',
                          },
                        ],
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '485d23d40fdd4686b3305787d1938c17',
                    title: '设备编码',
                    dataIndex: 'sbbm',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      defaultValue: '',
                      placeholder: '请输入设备编码',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: true,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '9637a074c0714669b9ed548f9b3c56b7',
                    title: '设备类型',
                    dataIndex: 'sblx',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      placeholder: '请选择下拉选择',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/jcxx//cjcx/getEquipmentType',
                        method: 'GET',
                        apiId: 'cd65b71f0c124581b331f52db2f9566b',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select lxid as value,lxmc as label from mes_equipment_dict where delete_mark = 0 and lxbm = \'type\' and zt = 1";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '661a0cf626084e3bac8e7f04f9350050',
                    title: '设备状态',
                    dataIndex: 'sbzt',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      placeholder: '请选择下拉选择',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/jcxx//cjcx/getEquipmentStatus',
                        method: 'GET',
                        apiId: '265de6946ca24f5588374a54ac3c6484',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select lxid as value,lxmc as label from mes_equipment_dict where delete_mark = 0 and lxbm = \'status\' and zt = 1";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '8eab0f870d2f44a3a4b96d9e3a48813b',
                    title: '规格型号',
                    dataIndex: 'ggxh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      defaultValue: '',
                      placeholder: '请输入规格型号',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '40d7c05f9998488084e250d6d274f6f0',
                    title: '厂家',
                    dataIndex: 'cj',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      defaultValue: '',
                      placeholder: '请输入厂家',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'dic',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: true,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const treeConfig = {
  id: '1768446768650727425',
  isMultiple: false,
  name: '静态',
  type: 1,
  configTip: '',
  config: [
    { bindFiled: '', name: '默认', value: 'value' },
    { bindFiled: '', name: '公司', value: 'value-2' },
    { bindFiled: '', name: '岗位', value: 'value-4' },
  ],
};
