import { Tag } from 'ant-design-vue';
import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { NewsCategoryDic } from '/@/enums/oa';
import { useI18n } from '/@/hooks/web/useI18n';
import { h } from 'vue';
const { t } = useI18n();
export const searchFormSchema: FormSchema[] = [
  {
    field: 'keyword',
    label: '',
    component: 'Input',
    colProps: { span: 8 },
    componentProps: {
      placeholder: t('请输入关键字'),
    },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'briefHead',
    title: '公告标题',
    componentType: 'input',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  // {
  //   dataIndex: 'authorName',
  //   title: '作者',
  //   componentType: 'input',
  //   // sorter: true,
  //   align: 'center',
  //   resizable: true,
  // },
  // {
  //   dataIndex: 'compileName',
  //   title: '编辑',
  //   componentType: 'input',
  //   // sorter: true,
  //   align: 'center',
  //   resizable: true,
  // },
  {
    dataIndex: 'categoryName',
    title: '公告类型',
    componentType: 'input',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'sourceName',
    title: '信息来源',
    componentType: 'input',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'releaseTime',
    title: '发布时间',
    componentType: 'date',
    // sorter: true,
    align: 'center',
    resizable: true,
  },
  {
    dataIndex: 'enabledMark',
    title: '发布状态',
    componentType: 'input',
    customRender: ({ record }) => {
      const color = record.enabledMark ? 'green' : 'blue';
      const text = record.enabledMark ? t('已发布') : t('未发布');
      return h(Tag, { color: color }, () => text);
    },
    // sorter: true,
    align: 'center',
    resizable: true,
  },
];
export const formProps: FormProps = {
  labelCol: { span: 4, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '54d4d5b63e954ad182b377489ce15ae2',
      field: 'briefHead',
      label: '公告标题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入公告标题',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        isSave: false,
        style: { width: '100%' },
      },
    },
    {
      key: '83f75ad3b07242f68b87839dd59d87a2',
      field: 'category',
      label: '公告类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择公告类型',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [],
        defaultSelect: 'Facts',
        datasourceType: 'dic',
        params: { itemId: NewsCategoryDic.ID },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        itemId: NewsCategoryDic.ID,
        style: { width: '100%' },
      },
    },
    {
      key: '1cce31f4c5c64e6ea322d3318b9a2fea',
      field: 'releaseTime',
      label: '发布时间',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择发布时间',
        format: 'YYYY-MM-DD HH:mm:ss',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'db6247b0c70f4abaa3774aac0cf229a0',
      field: 'sourceName',
      label: '信息来源',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入信息来源',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        isSave: false,
        style: { width: '100%' },
      },
    },
    {
      key: '7623d9786dee49b881457291425a7750',
      field: 'sourceAddress',
      label: '来源地址',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入来源地址',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        isSave: false,
        style: { width: '100%' },
      },
    },
    {
      key: '3ef88a44265b406a8527fb19ba87948f',
      field: 'newsContent',
      label: '内容',
      type: 'richtext-editor',
      component: 'RichTextEditor',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        disabled: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
