import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'cphm',
    label: '车辆号码',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/cheliang/py-list',
        method: 'GET',
        apiId: '81d881afe72d4be3a05677caa75e6342',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: '',
                required: false,
                dataType: 'String',
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          "\r\nvar sql = 'SELECT cl.id, cl.cllx, dic.`name` AS cllx_name, cl.gbzl, cl.cphm AS `value`, cl.cphm AS label ' +\r\n'FROM mes_base_cheliang cl ' +\r\n'LEFT JOIN ' +\r\n'(SELECT detail.`value`, detail.`name` ' +\r\n'FROM xjr_dictionary_item item ' +\r\n'LEFT JOIN xjr_dictionary_detail detail ON detail.item_id = item.id ' +\r\n'WHERE item.`code` = \"cllx\") dic ON cl.cllx = dic.`value` COLLATE utf8mb4_0900_ai_ci ' +\r\n'WHERE cl.sfcj = \"0\" ' +\r\n'?{keyword, AND cl.cphm LIKE CONCAT(\"%\", #{keyword}, \"%\")}'\r\nreturn db.select(sql);",
        outputParams: [
          { name: 'label', tableTitle: '车牌号码', bindField: '', show: true, width: 150 },
          { name: 'cllx_name', tableTitle: '车辆类型', bindField: '', show: true, width: 150 },
          {
            name: 'gbzl',
            tableTitle: '车辆重量',
            bindField: 'clzl',
            show: true,
            width: 150,
            component: 'ffba6da2c6be427388480ba9dbeda417',
          },
          {
            name: 'cllx',
            tableTitle: '',
            bindField: 'cllx',
            show: false,
            width: 150,
            component: 'b376e6f92fc94f75ab508964c7406d8a',
          },
          {
            name: 'id',
            tableTitle: '',
            bindField: 'cheliang_id',
            show: false,
            width: 150,
            component: '6aac9bdc31f74f969e4e94ff13b5a95f',
          },
        ],
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'gzr',
    label: '排液人',
    defaultValue: undefined,
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
  },

  {
    field: 'gzkssj',
    label: '工作开始时间',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'cllx',
    label: '车辆类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2017066632836796418' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'gzxm',
    label: '工作项目',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/cheliang/gzx',
        method: 'GET',
        apiId: 'd31f8fea01274bdf9f1f72464daa59e8',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [{ name: 'keyword', required: false, dataType: 'String', bindType: '' }],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql = \'SELECT id AS `value`, gzx AS label FROM mes_base_gongzuoxiang ?{keyword, WHERE gzx LIKE CONCAT("%", #{keyword}, "%")};\';\r\nreturn db.select(sql);',
        outputParams: [
          { name: 'label', tableTitle: '工作项目', bindField: '', show: true, width: 150 },
        ],
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'gzjssj',
    label: '工作结束时间',
    defaultValue: undefined,
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'cphm',
    title: '车辆号码',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cllx',
    title: '车辆类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clzl',
    title: '车辆重量(kg)',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzr',
    title: '排液人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzxm',
    title: '工作项目',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzkssj',
    title: '工作开始时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'gzjssj',
    title: '工作结束时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'clls',
    title: '处理辆数',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'ac7307293cde45ca8f87f91d169ec7ed',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '6aac9bdc31f74f969e4e94ff13b5a95f',
              field: 'cheliangId',
              label: '车辆id',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入车辆id',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '7542feb5b0de459baded633a4cb87763',
              field: 'cphm',
              label: '车辆号码',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择车辆号码',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '车辆号码',
                apiConfig: {
                  path: '/cheliang/py-list',
                  method: 'GET',
                  apiId: '81d881afe72d4be3a05677caa75e6342',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'keyword',
                          value: '',
                          required: false,
                          dataType: 'String',
                          bindType: 'value',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "\r\nvar sql = 'SELECT cl.id, cl.cllx, dic.`name` AS cllx_name, cl.gbzl, cl.cphm AS `value`, cl.cphm AS label ' +\r\n'FROM mes_base_cheliang cl ' +\r\n'LEFT JOIN ' +\r\n'(SELECT detail.`value`, detail.`name` ' +\r\n'FROM xjr_dictionary_item item ' +\r\n'LEFT JOIN xjr_dictionary_detail detail ON detail.item_id = item.id ' +\r\n'WHERE item.`code` = \"cllx\") dic ON cl.cllx = dic.`value` COLLATE utf8mb4_0900_ai_ci ' +\r\n'WHERE cl.sfcj = \"0\" ' +\r\n'?{keyword, AND cl.cphm LIKE CONCAT(\"%\", #{keyword}, \"%\")}'\r\nreturn db.select(sql);",
                  outputParams: [
                    { name: 'label', tableTitle: '车牌号码', show: true, width: 150 },
                    { name: 'cllx_name', tableTitle: '车辆类型', show: true, width: 150 },
                    {
                      name: 'gbzl',
                      tableTitle: '车辆重量',
                      bindField: 'clzl',
                      show: true,
                      width: 150,
                      component: 'ffba6da2c6be427388480ba9dbeda417',
                    },
                    {
                      name: 'cllx',
                      tableTitle: '',
                      bindField: 'cllx',
                      show: false,
                      width: 150,
                      component: 'b376e6f92fc94f75ab508964c7406d8a',
                    },
                    {
                      name: 'id',
                      tableTitle: '',
                      bindField: 'cheliangId',
                      show: false,
                      width: 150,
                      component: '6aac9bdc31f74f969e4e94ff13b5a95f',
                    },
                  ],
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'b8e63f39708d46cdb64fd9b5e9079dd4',
              field: 'gzr',
              label: '排液人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                width: '100%',
                defaultValue: '',
                placeholder: '请选择人员',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:setting-outlined',
                showLabel: true,
                disabled: false,
                required: false,
                multiple: true,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '3bf66ae914c64049bf385d556ceb2dc9',
              field: 'gzkssj',
              label: '工作开始时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择工作开始时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '0e1477cdb9f2472da86bd385c4c44ea5',
              field: 'bglx',
              label: '报工类型',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入报工类型',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'b376e6f92fc94f75ab508964c7406d8a',
              field: 'cllx',
              label: '车辆类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2017066632836796418' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2017066632836796418',
                style: { width: '100%' },
              },
            },
            {
              key: '16549fa420014b3f871e74e4274df5b3',
              field: 'gzxm',
              label: '工作项目',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择工作项目',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '工作项目',
                apiConfig: {
                  path: '/cheliang/gzx',
                  method: 'GET',
                  apiId: 'd31f8fea01274bdf9f1f72464daa59e8',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        { name: 'keyword', required: false, dataType: 'String', bindType: '' },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql = \'SELECT id AS `value`, gzx AS label FROM mes_base_gongzuoxiang ?{keyword, WHERE gzx LIKE CONCAT("%", #{keyword}, "%")};\';\r\nreturn db.select(sql);',
                  outputParams: [{ name: 'label', tableTitle: '工作项目', show: true, width: 150 }],
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '809f3945b0e34453a81f40a868675eb7',
              field: 'gzjssj',
              label: '工作结束时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择工作结束时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'ffba6da2c6be427388480ba9dbeda417',
              field: 'clzl',
              label: '车辆重量(kg)',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                min: 0,
                max: 1000000,
                step: 1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                placeholder: '请输入车辆重量(kg)',
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '234d3626d0fb4a41a10bf2f562eabce3',
              field: 'clls',
              label: '处理辆数',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                min: 0,
                max: 100,
                step: 1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                placeholder: '请输入处理辆数',
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '4074ceefdde44a77a11c2bc53cc3cdf3',
      field: 'bz',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: 500,
        rows: 4,
        autoSize: false,
        showCount: true,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '0d7ec3c4b4e54dfb9eeca107ec214d04',
      field: 'clqzp1',
      label: '处理前照片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: '',
        accept: '.jpg,.jpeg,.png,.bmp',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: true,
        disabled: false,
        required: false,
        isShow: true,
        events: {},
        listType: 'picture-card',
        sourceType: 'album,camera',
        tooltipConfig: { visible: false, title: '提示文本' },
      },
    },
    {
      key: '42b8984cc17f4cacafa3ae1e885d8260',
      field: 'clhzp1',
      label: '处理后照片',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: '#{upload}#',
        span: '',
        defaultValue: '',
        accept: '.jpg,.jpeg,.png,.bmp',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: true,
        disabled: false,
        required: false,
        isShow: true,
        events: {},
        listType: 'picture-card',
        sourceType: 'album,camera',
        tooltipConfig: { visible: false, title: '提示文本' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
