
import { MesDyxunjianRecordPageModel, MesDyxunjianRecordPageParams, MesDyxunjianRecordPageResult } from './model/YyydxjjlModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/yyydxjjl/page',
  List = '/scgl/yyydxjjl/list',
  Info = '/scgl/yyydxjjl/info',
  MesDyxunjianRecord = '/scgl/yyydxjjl',
  
  
  
}

/**
 * @description: 查询MesDyxunjianRecord分页列表
 */
export async function getMesDyxunjianRecordPage(params: MesDyxunjianRecordPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianRecordPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDyxunjianRecord信息
 */
export async function getMesDyxunjianRecord(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDyxunjianRecordPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDyxunjianRecord
 */
export async function addMesDyxunjianRecord(mesDyxunjianRecord: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDyxunjianRecord,
      params: mesDyxunjianRecord,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDyxunjianRecord
 */
export async function updateMesDyxunjianRecord(mesDyxunjianRecord: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDyxunjianRecord,
      params: mesDyxunjianRecord,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDyxunjianRecord（批量删除）
 */
export async function deleteMesDyxunjianRecord(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDyxunjianRecord,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




