import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface ConversionPageListParams {
  unitTypeId?: string; //单位类型
}
export interface ConversionDetailParamsModel {
  shiftUnitId: string; //单位Id
  baseUnitId: any;
  number: number; //数值
}

export interface ConversionAddParamsModel {
  addCaseErpUnitConvertDetailDtoList: ConversionDetailParamsModel[]; //单位换算配置
  baseUnitId?: string; //基准单位id
  unitTypeId?: string; //单位类型id
}

export interface ConversionUpdateParamsModel {
  id: string; //详情id
  addCaseErpUnitConvertDetailDtoList: ConversionDetailParamsModel[]; //单位换算配置
  baseUnitId?: string; //基准单位id
  unitTypeId?: string; //单位类型id
}

export interface ConversionListModel {
  id: string; //详情id
  unitTypeName: string; //单位类型
  unitTypeId: string; //单位类型id
  standardName: string; //基准单位
  quantity: string; //换算关系
  state: number; //状态 0-关闭 1-开启
}

export interface unitVoModel {
  isStandard: number; //是否是基准单位
  number: number; //换算值
  unitName: string; //单位名称
  symbol: string; //单位符号
}

export interface ConversionListAllModel {
  id: string; //详情id
  typeName: string; //单位类型名称
  state: number; //状态 0-关闭 1-开启
  unitVo: unitVoModel[]; //换算关系
}

export type ConversionPageListSearchModel = BasicPageParams & ConversionPageListParams;
export type ConversionPageListResultModel = BasicFetchResult<ConversionListModel>;
