## 技术选型

- 开发框架采用 [Vue3](https://v3.cn.vuejs.org/) 版本：3.3.4+
- 构建工具采用 [Vite](https://vitejs.cn/) 版本： 4.3.8+
- 包管理采用 [pnpm](https://www.pnpm.cn/)版本 6.20+
- 多语言框架采用 [i18n](https://vue-i18n.intlify.dev/) 版本 9.2.2
- ui 框架采用 [Ant-Design-Vue](https://2x.antdv.com/docs/vue/introduce-cn/) 版本：3.0+
- http 请求库 采用 [axios](https://www.axios-http.cn/) 版本 1.4.0+
- 代码计算库 采用 [jsbi-calculator](https://www.npmjs.com/package/jsbi-calculator) 版本 0.3.6+
- 框架开发语言采用 [TypeScript](https://www.typescriptlang.org/) 版本 5.0.4+
- 工作流组件采用 [bpmn.js](https://bpmn.io/toolkit/bpmn-js/) 版本 8.7+
- 时间工具库采用 [day.js](https://bpmn.io/toolkit/bpmn-js/) 版本 1.11.0+
- 状态管理库采用 [pinia ](https://https://pinia.vuejs.org/)版本 2.0.12 +
- 图表库采用 [echarts](https://echarts.apache.org/zh/index.html)版本 5.3.1+
- excel 操作库采用 [exceljs](https://github.com/exceljs/) 版本 4.3.0+
- 工具类采用 [lodash-es](https://www.lodashjs.com/) 版本 4.17.21+
- 工具类采用 [vueuse](https://vueuse.org/) 版本 10.1.2+
- 打印工具类库 采用 [printjs](https://printjs.crabbly.com/) 版本 1.6.0+
- 二维码类库 采用 [qrcode](https://www.qrcode.com/zh/) 版本 1.5.0+
- 拖拽组件 采用 [vuedraggable](https://www.npmjs.com/package/vue-draggable) 版本 4.1.0+
- 富文本编辑器 采用 [wangeditor](https://www.wangeditor.com/) 版本 4.6.3+
- 项目 git 提交管理库 采用 [husky](https://github.com/githusky) 版本 8.0.3+
- 项目框架结构采用 [Vben](https://vvbin.cn/doc-next/guide/introduction.html) 作为基础，搭建而成。
- 其他技术及版本 以 Vben 文档 以及 package.json 做参考

## 特性

- **最新技术栈**：使用 Vue3/vite3 等前端前沿技术开发
- **TypeScript**: 应用程序级 JavaScript 的语言
- **主题**：可配置的主题
- **国际化**：内置完善的国际化方案
- **Mock 数据** 内置 Mock 数据方案
- **权限** 内置完善的动态路由权限生成方案
- **组件** 二次封装了多个常用的组件

## 准备

- [node](http://nodejs.org/) 和 [git](https://git-scm.com/) -项目开发环境
- [Vite](https://vitejs.dev/) - 熟悉 vite 特性
- [Vue3](https://v3.vuejs.org/) - 熟悉 Vue 基础语法
- [TypeScript](https://www.typescriptlang.org/) - 熟悉`TypeScript`基本语法
- [Es6+](http://es6.ruanyifeng.com/) - 熟悉 es6 基本语法
- [Vue-Router-Next](https://next.router.vuejs.org/) - 熟悉 vue-router 基本使用
- [Ant-Design-Vue](https://2x.antdv.com/docs/vue/introduce-cn/) - ui 基本使用
- [Mock.js](https://github.com/nuysoft/Mock) - mockjs 基本语法

## 安装使用

<!-- - 获取项目代码

```sh
git clone https://gitee.com/zexy/xjrsoft-vue3.git
``` -->

- 安装依赖

```sh
cd xjrsoft-vue3

pnpm install

```

- 运行

```sh
pnpm dev
```

- 打包

```sh
pnpm build
```

<br/>

## Git 贡献提交规范

- 参考 [vue](https://github.com/vuejs/vue/blob/dev/.github/COMMIT_CONVENTION.md) 规范 [Angular](https://github.com/conventional-changelog/conventional-changelog/tree/master/packages/conventional-changelog-angular))
  - `feat` 增加新功能
  - `fix` 修复问题/BUG
  - `style` 代码风格相关无影响运行结果的
  - `perf` 优化/性能提升
  - `refactor` 重构
  - `revert` 撤销修改
  - `test` 测试相关
  - `docs` 文档/注释
  - `chore` 依赖更新/脚手架配置修改等
  - `workflow` 工作流改进
  - `ci` 持续集成
  - `types` 类型定义文件更改
  - `wip` 开发中

## 相关仓库

- [vite-plugin-mock](https://github.com/anncwb/vite-plugin-mock) - 用于本地及开发环境数据 mock
- [vite-plugin-html](https://github.com/anncwb/vite-plugin-html) - 用于 html 模版转换及压缩
- [vite-plugin-style-import](https://github.com/anncwb/vite-plugin-style-import) - 用于组件库样式按需引入
- [vite-plugin-theme](https://github.com/anncwb/vite-plugin-theme) - 用于在线切换主题色等颜色相关配置
- [vite-plugin-imagemin](https://github.com/anncwb/vite-plugin-imagemin) - 用于打包压缩图片资源
- [vite-plugin-compression](https://github.com/anncwb/vite-plugin-compression) - 用于打包输出.gz|.brotil 文件
- [vite-plugin-svg-icons](https://github.com/anncwb/vite-plugin-svg-icons) - 用于快速生成 svg 雪碧图
