import {
  url,
  aiKey
} from '@/config';
import request from '../axios'
const baseUrl = url + '/ai'
const aiBaseUrl = 'https://api.siliconflow.cn'
const authorization = 'Bearer '+ aiKey

// 获取模型列表
export const getModelList = () => {
  return request({
    url: `${aiBaseUrl}/v1/models`,
    method: 'GET',
    headers: {
      authorization: authorization
    }
  })
}

// 发送消息获取回复
export const sendMessage = (messages, model = 'deepseek-ai/DeepSeek-V2.5', config = {}) => {
  // 设置默认参数
  const defaultConfig = {
    temperature: 0.7,
    max_tokens: 4096,
    top_p: 1,
    frequency_penalty: 0,
    logprobs: false,
    top_logprobs: 0
  }

  // 合并配置参数
  const finalConfig = {
    ...defaultConfig,
    ...config,
    model: model,
    messages: messages,
    stream: true
  }

  return fetch(`${aiBaseUrl}/v1/chat/completions`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      authorization: authorization
    },
    body: JSON.stringify(finalConfig)
  })
}

export const getList = (params) => request({
  url: baseUrl + '/list',
  method: 'get',
  params: params
});



export const getObj = (id) => request({
  url: baseUrl + '/detail',
  method: 'get',
  params: {
    id
  }
});

export const add = (data) => request({
  url: baseUrl + '/save',
  method: 'post',
  data: data
});
export const update = (data) => request({
  url: baseUrl + '/update',
  method: 'post',
  data: data
});



export const remove = (id) => request({
  url: baseUrl + '/remove',
  method: 'post',
  params: {
    ids: id
  }
});

/**
 * LLM聊天完成接口
 * @param {Array} messages - 消息数组
 * @param {Object} config - 模型配置
 * @returns {Promise} - 返回LLM响应结果
 */
export const chatCompletion = async (messages, config = {}) => {
  return request({
    url: `${aiBaseUrl}/v1/chat/completions`,
    method: 'POST',
    headers: {
      authorization: authorization
    },
    data: {
      messages,
      model: config.model || 'deepseek-ai/DeepSeek-V3',
      max_tokens: config.max_tokens || 4096,
      temperature: config.temperature || 0.7,
      top_p: config.top_p || 1,
      stream:false,
      frequency_penalty: config.frequency_penalty || 0,
      presence_penalty: config.presence_penalty || 0
    }
  })
}