import {
  resolve
} from 'path'
export default {
  //打包index.umd.js的配置
  publicDir: 'access', // 指定public目录的位置
  build: {
    cssCodeSplit: true,
    lib: {
      entry: resolve(__dirname, 'src/index.js'),
      name: 'AvueData',
      fileName: 'index',
      formats: ['umd']
    },
    outDir: resolve(__dirname, 'public/lib'),
    assetsDir: "assets",
    minify: 'esbuild',
    esbuild: {
      // 进一步定制压缩选项
      drop: ['console', 'debugger'], // 删除 console 和 debugger 语句
      minifyWhitespace: true,         // 删除空白字符
      minifySyntax: true,            // 删除多余的语法
      minifyIdentifiers: true,       // 压缩变量名
    },
    rollupOptions: {
      external: ['vue', 'axios', '@smallwei/avue','element-plus'],
      output: {
        compact: true,
        globals: {
          'element-plus':'ElementPlus',
          vue: 'Vue',
          '@smallwei/avue': 'AVUE',
          axios: 'axios'
        },
      },
    },
  },
}