import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesSystemParam分页参数 模型
 */
export interface MesSystemParamPageParams extends BasicPageParams {
  paramName: string;

  paramKey: string;
}

/**
 * @description: MesSystemParam分页返回值模型
 */
export interface MesSystemParamPageModel {
  id: string;

  paramName: string;

  paramKey: string;

  paramValue: string;

  enabled: string;
}

/**
 * @description: MesSystemParam表类型
 */
export interface MesSystemParamModel {
  id: string;

  paramName: string;

  paramKey: string;

  paramValue: string;

  description: string;

  enabled: string;

  createDate: string;

  modifyDate: string;

  createUserId: string;

  modifyUserId: string;
}

/**
 * @description: MesSystemParam分页返回值结构
 */
export type MesSystemParamPageResult = BasicFetchResult<MesSystemParamPageModel>;
