import { BasicFetchResult, BasicPageParams, BIFetchResult } from '/@/api/model/baseModel';

/**
 * @description:  模型
 */
export type BiListParams = BasicPageParams;

export interface BiReleaseListModel {
  id: string; //主键
  name: string; //菜单名称
  menuId: string; //菜单id
  parentId: string; //上级菜单id
  code: string; //菜单编号
  sortCode: number; //排序号
  remark: string; //备注
  visualId: string; //BIid
}

export interface BiReleaseModel {
  id: string; //主键
  name: string; //菜单名称
  menuId: string; //菜单id
  parentId: string; //上级菜单id
  code: string; //菜单编号
  sortCode: number; //排序号
  remark: string; //备注
  visualId: string; //BIid
}

/**
 * @description: Request list return value
 */
export type BiReleaseListResultModel = BasicFetchResult<BiReleaseListModel>;
export type BiListResultModel = BIFetchResult<BiReleaseListModel>;

export type BiReleaseList = Array<BiReleaseListModel>;
