import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'materialId',
    label: '物料ID',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialNo',
    label: '物料编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialName',
    label: '物料名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'model',
    label: '规格型号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'unity',
    label: '单位',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'workNum',
    label: '报工数量',
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
    colProps: { span: 8 },
  },
  {
    field: 'workDev',
    label: '设备',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getDevList',
        method: 'GET',
        apiId: 'copy1690854319515d98152',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(keyword!=null&&keyword!=""){ \r\n    condition+=" and dev_name like \'%#{keyword}%\'";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT d.id AS `key` ,d.id AS `value`,CONCAT(d.dev_name) AS label,d.id,d.dev_code,d.dev_name,d.dev_type,dt.type_name AS `dev_type_name`,d.dev_manage,d.dev_phone,d.dev_file2 FROM mes_dev d"\r\n+" LEFT  JOIN mes_dev_type dt ON d.dev_type=dt.id "\r\n+" where d.state=1  and d.delete_mark=0 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'userStation',
    label: '工位',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/mesFactory',
        method: 'GET',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'factory_type',
                value: '3',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'factory_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'car_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'materialId',
    title: '物料ID',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialNo',
    title: '物料编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialName',
    title: '物料名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'model',
    title: '规格型号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'workNum',
    title: '报工数量',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'workDev',
    title: '设备',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'userStation',
    title: '工位',
    componentType: 'select',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '26efb4d1f1a94a2d9a5b674d108b93eb',
      field: 'materialId',
      label: '物料ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料ID',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '49f6b04fcd2043c9b40e7f93c82916a5',
      field: 'materialNo',
      label: '物料编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'c4ee0ab3d70346c7bf190848ea2e736a',
      field: 'materialName',
      label: '物料名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '659b1f49a1a249cca1bfd2b788a0fda2',
      field: 'model',
      label: '规格型号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入规格型号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '910279646c2b4e309928b3237c008759',
      field: 'unity',
      label: '单位',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入单位',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '97c0e1cf230d46f1844e3182be95c398',
      field: 'workNum',
      label: '报工数量',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: null,
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: null,
        min: 0,
        max: null,
        step: 1,
        maxlength: null,
        disabled: false,
        showLabel: true,
        controls: true,
        required: false,
        subTotal: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '6a34805cacb14eeebdcf6a9ae360217b',
      field: 'workDev',
      label: '设备',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getDevList',
          method: 'GET',
          apiId: 'copy1690854319515d98152',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(keyword!=null&&keyword!=""){ \r\n    condition+=" and dev_name like \'%#{keyword}%\'";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT d.id AS `key` ,d.id AS `value`,CONCAT(d.dev_name) AS label,d.id,d.dev_code,d.dev_name,d.dev_type,dt.type_name AS `dev_type_name`,d.dev_manage,d.dev_phone,d.dev_file2 FROM mes_dev d"\r\n+" LEFT  JOIN mes_dev_type dt ON d.dev_type=dt.id "\r\n+" where d.state=1  and d.delete_mark=0 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'e0a301b770b944f2b928037dfa7e5724',
      field: 'userStation',
      label: '工位',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '3',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
