import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'onlineDate',
    label: '上线日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '待生成工单', value: '1' },
        { key: 2, label: '生产中', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'materialNo',
    label: '物料编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialName',
    label: '物料名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'orderNo',
    label: '生产订单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'saleOrderNo',
    label: '销售单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  // {
  //   field: 'createUserId',
  //   label: '创建人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createDate',
  //   label: '创建时间',
  //   component: 'RangePicker',
  //   componentProps: {
  //     showTime: true,
  //     style: { width: '100%' },
  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'id',
    title: '生产计划编号',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'onlineDate',
    title: '上线日期',
    componentType: 'date',
    sorter: true,
  },
  {
    dataIndex: 'materialNo',
    title: '物料编码',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'materialName',
    title: '物料名称',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '待生成工单', value: '1' },
        { key: 2, label: '生产中', value: '2' },
        { key: 3, label: '已作废', value: '3' },
      ];
      return staticOptions.filter((x) => x.value === record.state)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'priority',
    title: '优先级',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'planNum',
    title: '计划产量',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'orderNo',
    title: '生产订单号',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'saleOrderNo',
    title: '销售单号',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'carId',
    title: '车间',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'lineId',
    title: '产线',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'craftId',
    title: '工艺',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'planStartDate',
    title: '计划开工日期',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'planEndDate',
    title: '计划完工日期',
    componentType: 'input',
    sorter: true,
  },
  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',
    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',
    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'c945b9bc69ca4b0e961a22990015a31c',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '订单信息',
      componentProps: {
        defaultValue: '订单信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0c9075b098c84112ae88da741b71d7e4',
      field: 'orderNo',
      label: '生产订单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产订单号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '043095df812f4426965ba2230acf7351',
      field: 'saleOrderNo',
      label: '销售单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入销售单号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '167c1885b48e47b1857bd2839e2d974c',
      field: 'onlineDate',
      label: '上线日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择上线日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'fe149dbc6971422ba28441577e96fd40',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 0,
        style: { width: '100%' },
      },
    },
    {
      key: '4f172ff32b4e49dd99ef4449e6126840',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 2,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 0,
        style: { width: '100%' },
      },
    },
    {
      key: '64f0ca60cb6845beb12ce4dc76a76425',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '生产明细',
      componentProps: {
        defaultValue: '生产明细',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'b4f0e8ac619f4fa3b771ea6bb8136b01',
      label: '',
      field: 'mesProOrderplan2List',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProOrderplan2List',
        columns: [
          {
            key: '64a4b928c6e344f3b1527007ad9e03a4',
            title: '层级',
            dataIndex: 'priority',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '81bcbfb7783c48c699e96f11a7bfcddd',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '物料ID请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '928f0a24681e4e2f9f59ee249713cda5',
            title: '物料编码',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '0288fffa48424cc39acb1cffde170037',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '4e0cdc1060714f28b5939e43b10c7b25',
            title: '规格型号',
            dataIndex: 'speModel',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'a894c0cfd0884c79979de1ff561b93fb',
            title: '物料类别',
            dataIndex: 'materialType',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '303f008cd27642b697ebbb3ecc92600c',
            title: '物料属性',
            dataIndex: 'materialProperty',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '6445102957584c75bedb9e633fd6e3a9',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'ffa27c618711495cb01371828295a7f4',
            title: '计划产量',
            dataIndex: 'planNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '94f1f0c9e25943b787905515d179aed4',
            title: '车间',
            dataIndex: 'carId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '1',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '1c11989d58cd4212b9402de138f7a641',
            title: '产线',
            dataIndex: 'lineId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '2',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'cdf524dbaad146b1b3c2c54eba5ab973',
            title: '生产工艺',
            dataIndex: 'craftId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getWorkOrderList_copy',
                method: 'GET',
                apiId: 'copy1691738160514d20686',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'keyword',
                        value: null,
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'showLabel',
                        value: 'name',
                        description: '回显字段',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: 'name',
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'queryType',
                        value: null,
                        description: '查询类型',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'state',
                        value: null,
                        description: '状态',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.process_name AS label,t.*  FROM mes_process_technology t WHERE 1=1  "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
