import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'errorNo',
    label: '异常报告编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'errorType',
    label: '不良类别',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686641031350390786' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorNum',
    label: '不良数',
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorRate',
    label: '不良率(%)',
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
    colProps: { span: 8 },
  },
  {
    field: 'judgeResult',
    label: '判定依据',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckStandard',
        apiId: '6967f0799cec4087bbfacae79faa0606',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'reportNo',
    label: '来料检验报编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportName',
    label: '来料检验报告名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  // {
  //   field: 'createUserId',
  //   label: '异常报告创建人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createDate',
  //   label: '异常报告创建时间',
  //   component: 'Info',
  //   colProps: { span: 8 },
  // },

  {
    field: 'errorState',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686656230883135490' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'remark',
  //   label: '问题描述',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'errorNo',
    title: '异常报告编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'errorType',
    title: '不良类别',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'errorNum',
    title: '不良数',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'errorRate',
    title: '不良率(%)',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '判定依据',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'reportNo',
    title: '来料检验报编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '来料检验报告名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '异常报告创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '异常报告创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '问题描述',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '130px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'cdb4b8974847421498bf68536101a5d5',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '来料检验报告信息',
      componentProps: {
        defaultValue: '来料检验报告信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9f8ff71bbd3e4818a68d829f4e9cc432',
      field: 'reportId',
      label: '来料检验报告ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: false,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入来料检验报告ID',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8fcc6c87dd5741d7a19a724676a1eb83',
      field: 'reportNo',
      label: '来料检验报编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入来料检验报编码',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '55a772c2fd81491f96b89bb761e27bd4',
      field: 'reportName',
      label: '来料检验报告名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入来料检验报告名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '2dd87f6a1bfa4856852ed5ff184093a3',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '异常报告填写',
      componentProps: {
        defaultValue: '异常报告填写',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'cf73476fa59c4b94ba6818b50df9bbc0',
      field: 'errorNo',
      label: '异常报告编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入异常报告编码',
        addonBefore: '',
        autoCodeRule: 'mescheckErrorNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '399d82c9388c417c9023499a498459f8',
      field: 'isSysNum',
      label: '使用系统编号',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '使用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='errorNo';\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: 'e83452d0338448e39bf08bd52bc40722',
      field: 'errorType',
      label: '不良类别',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        ifShow: true,
        params: { itemId: '1686641031350390786' },
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1686641031350390786',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: false,
        placeholder: '请选择不良类别',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '9082873945ef40588f93212c36d756ee',
      field: 'errorNum',
      label: '不良数',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        controls: true,
        //max: 100
        rules: [],
        subTotal: false,
        ifShow: true,
        showLabel: true,
        required: true,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '27039e2948364adca17f86be985f46b8',
      field: 'errorRate',
      label: '不良率(%)',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        controls: true,
        //max: 100
        rules: [],
        subTotal: false,
        ifShow: true,
        showLabel: true,
        required: true,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '05cd901b65c543c392d7ccb4c02d71ff',
      field: 'judgeResult',
      label: '判定依据',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择判定依据',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '48539527c5f84919a0a64bc44b37592c',
      field: 'remark',
      label: '问题描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        ifShow: true,
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入问题描述',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '04815c4f50d446ac86291e4a05eb719f',
      field: 'errorState',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1686656230883135490',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: true,
        placeholder: '',
        staticOptions: [
          { label: '待发起', value: '0', key: 1 },
          { label: '审核中', value: '1', key: 2 },
          { label: '审核完成', value: '2', key: 3 },
        ],
        events: {},
        span: '',
        params: { itemId: '1686656230883135490' },
        style: { width: '100%' },
      },
    },
    {
      key: '0bc67be6d9ea41e29ddb3192f4617864',
      field: 'createUserId',
      label: '异常报告创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ecff667615854517ae49a241e1b6642e',
      field: 'createDate',
      label: '异常报告创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 3,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
