import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { RuleProcessListModel } from './model';

enum Api {
  List = '/liteflow/design/list',
  Design = '/liteflow/design',
  Page = '/liteflow/design/page',
  getEventList = '/liteflow/chain/comp',
  Info = '/liteflow/design/info',
  Test = '/liteflow/test/test',
  Execute = '/liteflow/test/execute',
}
/**
 * @description: 测试
 */
export async function RuleProcessTest(data, mode: ErrorMessageMode = 'modal') {
  return defHttp.post(
    {
      url: Api.Test,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 执行
 */
export async function RuleProcessExecute(
  designId,
  processParamConfigs,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post(
    {
      url: Api.Execute,
      data: { designId, processParamConfigs },
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询详情
 */
export async function getRuleProcessInfo(id, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RuleProcessListModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询所有规则文件列表（不分页）
 */
export async function getRuleProcessList(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RuleProcessListModel[]>(
    {
      url: Api.List,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询所有规则文件列表（分页）
 */
export async function getRuleProcessPage(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除
 */
export async function deleteRuleProcess(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Design,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 新增
 */
export async function addRuleProcess(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.post(
    {
      url: Api.Design,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 编辑
 */
export async function updateRuleProcess(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.put(
    {
      url: Api.Design,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
export async function getRuleProcessListEventList(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<Array<string>>(
    {
      url: Api.getEventList,
    },
    {
      errorMessageMode: mode,
    },
  );
}
