import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseIn分页参数 模型
 */
export interface MesWarehouseInPageParams extends BasicPageParams {
  inCode: string;

  inType: string;

  inName: string;

  inDate: string;

  inStorage: string;

  inUser: string;

  inDouser: string;

  relevancePro: string;

  remark: string;
}

/**
 * @description: MesWarehouseIn分页返回值模型
 */
export interface MesWarehouseInPageModel {
  id: string;

  inCode: string;

  inType: string;

  inName: string;

  inDate: string;

  inStorage: string;

  inNum: string;

  inUser: string;

  relevancePro: string;

  remark: string;
}

/**
 * @description: MesWarehouseIn表类型
 */
export interface MesWarehouseInModel {
  id: number;

  isSysNum: string;

  inCode: string;

  inName: string;

  inType: string;

  inDate: string;

  proRemark: string;

  inStorage: string;

  inUser: string;

  inNum: string;

  inDouser: string;

  relevancePro: string;

  buyId: string;

  buyNo: string;

  supplier: string;

  supplierId: string;

  supplierUser: string;

  supplierPhone: string;

  buyUnit: string;

  buyUser: string;

  produceId: string;

  produceNo: string;

  produceUnit: string;

  workorderId: string;

  workorderNo: string;

  reMaterialUnit: string;

  reMaterialUser: string;

  reMaterialRemark: string;

  saleId: string;

  saleNo: string;

  saleCustomer: string;

  saleManager: string;

  saleUnit: string;

  saleUser: string;

  salePhone: string;

  putIn: string;

  inFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesWarehouseInDetailList?: MesWarehouseInDetailModel;
}

/**
 * @description: MesWarehouseInDetail表类型
 */
export interface MesWarehouseInDetailModel {
  id: number;

  inId: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  unity: string;

  warArea: string;

  locationId: string;

  batchno: string;

  planProduce: string;

  price: string;

  num: string;

  curInNum: string;

  totalPrice: string;

  hasIn: string;

  produceDate: string;

  endDate: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseIn分页返回值结构
 */
export type MesWarehouseInPageResult = BasicFetchResult<MesWarehouseInPageModel>;
