
import { MesWarehousePromaterialPageModel, MesWarehousePromaterialPageParams, MesWarehousePromaterialPageResult } from './model/ScllModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/scll/page',
  List = '/ckgl/scll/list',
  Info = '/ckgl/scll/info',
  MesWarehousePromaterial = '/ckgl/scll',
  
  
  
}

/**
 * @description: 查询MesWarehousePromaterial分页列表
 */
export async function getMesWarehousePromaterialPage(params: MesWarehousePromaterialPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehousePromaterialPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehousePromaterial信息
 */
export async function getMesWarehousePromaterial(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehousePromaterialPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehousePromaterial
 */
export async function addMesWarehousePromaterial(mesWarehousePromaterial: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehousePromaterial,
      params: mesWarehousePromaterial,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehousePromaterial
 */
export async function updateMesWarehousePromaterial(mesWarehousePromaterial: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehousePromaterial,
      params: mesWarehousePromaterial,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehousePromaterial（批量删除）
 */
export async function deleteMesWarehousePromaterial(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehousePromaterial,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




