
import { MesTrqxunjianRecordPageModel, MesTrqxunjianRecordPageParams, MesTrqxunjianRecordPageResult } from './model/TrqxjdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/trqxjd/page',
  List = '/scgl/trqxjd/list',
  Info = '/scgl/trqxjd/info',
  MesTrqxunjianRecord = '/scgl/trqxjd',
  
  
  
}

/**
 * @description: 查询MesTrqxunjianRecord分页列表
 */
export async function getMesTrqxunjianRecordPage(params: MesTrqxunjianRecordPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesTrqxunjianRecordPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesTrqxunjianRecord信息
 */
export async function getMesTrqxunjianRecord(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesTrqxunjianRecordPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesTrqxunjianRecord
 */
export async function addMesTrqxunjianRecord(mesTrqxunjianRecord: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesTrqxunjianRecord,
      params: mesTrqxunjianRecord,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesTrqxunjianRecord
 */
export async function updateMesTrqxunjianRecord(mesTrqxunjianRecord: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesTrqxunjianRecord,
      params: mesTrqxunjianRecord,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesTrqxunjianRecord（批量删除）
 */
export async function deleteMesTrqxunjianRecord(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesTrqxunjianRecord,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




