import { MesDevTypeModel, MesDevTypePageParams, MesDevTypePageResult } from './model/DevTypeModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/devtype/page',
  List = '/mes/devtype/list',
  Info = '/mes/devtype/info',
  MesDevType = '/mes/devtype',

  Export = '/mes/devtype/export',
}

/**
 * @description: 查询MesDevType分页列表
 */
export async function getMesDevTypePage(
  params: MesDevTypePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesDevTypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDevType信息
 */
export async function getMesDevType(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDevTypeModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDevType
 */
export async function addMesDevType(mesDevType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDevType,
      params: mesDevType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDevType
 */
export async function updateMesDevType(mesDevType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesDevType,
      params: mesDevType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDevType（批量删除）
 */
export async function deleteMesDevType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDevType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesDevType
 */
export async function exportMesDevType(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
