import { ref } from 'vue';
import { useI18n } from '/@/hooks/web/useI18n';
import type { SelectProps } from 'ant-design-vue';
import { TableType } from '/@/enums/desktop';
import { CustomButtonModalType } from '/@/enums/userEnum';
const { t } = useI18n();

export const basicLayout = [
  {
    typeName: t('左右布局'),
    type: 'vertical',
    customIcon: 'ant-design:layout-filled',
    layout: [
      { type: 'left', list: [] },
      { type: 'right', list: [] },
    ],
    options: {
      label: t('左右布局'),
      showLabel: true,
      showLeft: true,
      leftWidth: 200,
      showRight: true,
    },
  },
  {
    typeName: t('上下布局'),
    type: 'horizontal',
    customIcon: 'ant-design:pic-center-outlined',
    layout: [
      { type: 'top', list: [] },
      { type: 'center', list: [] },
      { type: 'bottom', list: [] },
    ],
    options: {
      label: t('上下布局'),
      showLabel: true,
      showTop: true,
      topHeight: '',
      showBottom: true,
      bottomHeight: '',
    },
  },
  {
    typeName: t('常规布局'),
    type: 'normal',
    customIcon: 'ant-design:pic-right-outlined',
    layout: [
      { type: 'left', list: [] },
      { type: 'top', list: [] },
      { type: 'bottom', list: [] },
    ],
    options: { label: t('常规布局'), showLabel: true, showLeft: true, leftWidth: 200 },
  },
  {
    typeName: t('表格布局'),
    type: 'table-layout',
    layout: [
      {
        list: [
          {
            width: '',
            height: '',
            class: 'tableLayoutTd',
            children: [],
            position: [0, 0],
          },
          {
            width: '',
            height: '',
            class: 'tableLayoutTd',
            children: [],
            position: [0, 1],
          },
        ],
      },
    ],
    options: {
      label: t('表格布局'),
      borderWidth: 1,
      borderColor: '#ddd',
      class: '',
      isShow: true,
      showLabel: true,
    },
  },
];

export const customLayout = [
  {
    typeName: t('折叠布局'),
    type: 'collapse',
    customIcon: 'ant-design:appstore-filled',
    layout: [
      { key: 0, title: '折叠面板标题1', list: [] },
      { key: 1, title: '折叠面板标题2', list: [] },
    ],
    options: {
      collapseType: 'show',
    },
  },
  {
    typeName: t('面板布局'),
    type: 'panel',
    customIcon: 'ant-design:profile-twotone',
    layout: [{ title: '面板布局名称', list: [] }],
    options: { showLabel: true },
  },
  {
    typeName: t('选项卡布局'),
    type: 'tab',
    layout: [
      {
        name: 'tab1',
        span: 24,
        prefix: '',
        suffix: '',
        activeColor: '#1c8dff',
        folderId: '',
        imageUrl: '',
        conImageUrl: '',
        conFolderId: '',
        list: [],
      },
      {
        name: 'tab2',
        span: 24,
        prefix: '',
        suffix: '',
        activeColor: '#1c8dff',
        folderId: '',
        imageUrl: '',
        conImageUrl: '',
        conFolderId: '',
        list: [],
      },
      {
        name: 'tab3',
        span: 24,
        prefix: '',
        suffix: '',
        activeColor: '#1c8dff',
        folderId: '',
        imageUrl: '',
        conImageUrl: '',
        conFolderId: '',
        list: [],
      },
    ],
    options: {
      tabPosition: 'top',
      type: 'line',
      isShow: true,
    },
  },
];
//按钮组件
export const basicComponent = [
  {
    typeName: t('树形组件'),
    type: 'tree',
    customIcon: 'ant-design:apartment-outlined',
    options: {
      label: t('树形组件'),
      showLabel: true,
      treeConfig: {
        id: '1768446768650727425',
      },
      datasourceType: 'static',
      apiConfig: {},
      events: {},
    },
  },
  {
    typeName: t('查询组件'),
    type: 'search',
    customIcon: 'ant-design:search-outlined',
    options: { label: t('查询组件'), schemas: [], events: {} },
  },
  {
    typeName: t('列表组件'),
    type: 'list',
    customIcon: 'ant-design:bars-outlined',
    options: {
      label: t('列表组件'),
      type: TableType.API,
      columns: [],
      dataList: [],
      buttonList: [
        {
          isUse: true,
          name: t('新增'),
          code: 'add',
          isDefault: true,
        },
        {
          isUse: true,
          name: t('编辑'),
          code: 'edit',
          isDefault: true,
          showType: 'inline',
        },
        {
          isUse: true,
          name: t('删除'),
          code: 'delete',
          isDefault: true,
          showType: 'inline',
        },
      ],
      pageSize: 5,
      apiConfig: {
        id: '271e22922d9843d8badd270c685636cd',
        name: '列表表格数据',
        method: 'GET',
        script:
          "// 适用于信息列表，API型表格\r\nvar sql = 'select Commodity_name as \"name\",Commodity_quantity as \"quantity\",Commodity_price as \"price\", round(Commodity_price/Commodity_quantity, 2) as \"unitPrice\" from xjr_assco_selection_data';\r\nif (keyword != null && keyword != '' && keyword != 'null' && keyword != 'undefined') {\r\n    keyword = \"%\" + keyword + \"%\";\r\n    sql = sql + \" where Commodity_name like '\" + keyword + \"'\";\r\n}\r\nlimit = (limit - 1) * size;\r\nvar page = db.page(sql, size, limit);\r\nvar result = {};\r\nresult.list = page.list;\r\nresult.total = page.total;\r\nresult.columns = [{prop:'name',label:'名称'},{prop:'quantity',label:'数量'},{prop:'price',label:'价格'},{prop:'unitPrice',label:'单价'}]\r\n\r\nreturn result;",
        path: 'DesktopDesign/list-chart',
        requestParamsConfigs: [
          {
            name: 'limit',
            dataType: 'Integer',
            assignmentType: 'value',
            value: '1',
            config: '',
          },
          {
            name: 'size',
            dataType: 'Integer',
            assignmentType: 'value',
            value: '5',
            config: '',
          },
          {
            name: 'keyword',
            dataType: 'String',
            assignmentType: 'value',
            value: '',
            config: '',
          },
        ],
        requestHeaderConfigs: [],
        requestBodyConfigs: [],
      },
      refreshComponent: [],
      events: {},
    },
  },
  {
    typeName: t('表单组件'),
    type: 'form',
    options: {
      label: t('表单组件'),
      showLabel: true,
      refreshComponent: [],
      setFormDatas: [],
      formId: '',
      events: {},
    },
  },
  {
    typeName: t('图形组件'),
    type: 'chart',
    customIcon: 'ant-design:area-chart-outlined',
    options: { label: t('图形组件'), chartType: '', width: '100%', height: '350px' },
  },
  {
    typeName: 'iframe组件',
    type: 'iframe',
    options: {
      label: 'iframe组件',
      url: '',
      list: [],
      width: '100%',
      height: '200px',
      refreshComponent: [],
    },
  },
  {
    typeName: t('按钮组件'),
    type: 'button',
    options: {
      buttons: [
        {
          code: 'chaxun1234',
          name: '查询',
          style: 'primary',
          type: CustomButtonModalType.COMMON,
          event: [],
          clickEvent: '',
        },
      ],
    },
  },
];
export const isFirstLevel = ['vertical', 'horizontal', 'normal', 'table-layout'];
export const betterPropertyLayout = [
  'vertical',
  'horizontal',
  'normal',
  'collapse',
  'form',
  'iframe',
  'list',
];
export const needDatas = ['tree', 'form', 'list', 'search']; //参与数据刷新的组件
export interface TableCell {
  class?: string; //类名
  height?: number; //高
}
export interface TableTh {
  class?: string; //类名
  width?: number; //宽
}
export enum PlatformType {
  Antd,
  Element,
}
export const collapseTypeOption = ref<SelectProps['options']>([
  {
    value: 'show',
    label: '展开',
  },
  {
    value: 'hide',
    label: '收起',
  },
]);

export interface ApiItem {
  key: string;
  label: string;
  children: Array<ApiItem>;
  renderIcon?: string;
}

export enum searchCompType {
  text,
  select,
  cycle,
  date,
  time,
  radio,
  finance,
}

export enum datasourceType {
  api,
  dic,
  static,
}
export enum dataFromType {
  info = 'currentInfo',
  table = 'table',
  search = 'search',
  tree = 'tree',
  form = 'form',
}

export enum chartType {
  line,
  pie,
  radar,
  gauge,
  funnel,
  barPercent,
  barStack,
}

export const exampleStr = ` {
  code: 0,
  msg: 'success',
  data: {
    total:20,
    columns: [
      {prop:'name',label:'测试1'},
      {prop:'value',label:'测试2'}
    ],
    list: [
      {name:'demo1',value:10},
      {name:'demo2',value:30}
    ],
  },
}`;

export interface SearchDate {
  fieldName: string;
  format: string;
}

export const fieldsNames = ref<SelectProps['options']>([
  {
    value: 'label',
    label: 'label',
  },
  {
    value: 'value',
    label: 'value',
  },
]);

export const chartOptions = ref<SelectProps['options']>([
  {
    label: '折/柱',
    value: chartType.line,
  },
  {
    label: '饼图',
    value: chartType.pie,
  },
  {
    label: '雷达图',
    value: chartType.radar,
  },
  {
    label: '仪表盘',
    value: chartType.gauge,
  },
  {
    label: '漏斗图',
    value: chartType.funnel,
  },
  {
    label: '百分比',
    value: chartType.barPercent,
  },
  {
    label: '甘特图',
    value: chartType.barStack,
  },
]);

export const pageSizeOptions = ref<SelectProps['options']>([
  { value: 5 },
  { value: 10 },
  { value: 15 },
  { value: 20 },
  { value: 25 },
  { value: 30 },
  { value: 35 },
  { value: 40 },
  { value: 45 },
  { value: 50 },
]);

export const alignOptions = ref<SelectProps['options']>([
  {
    value: 'left',
    label: '左对齐',
  },
  {
    value: 'center',
    label: '中间对齐',
  },
  {
    value: 'right',
    label: '右边对齐',
  },
]);
