import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: XjrMyapp分页参数 模型
 */
export interface XjrMyappPageParams extends BasicPageParams {
  appName: string;

  appCode: string;

  appType: string;

  appVersion: string;

  appCodetype: string;

  appMemuids: string;

  appInterfaceids: string;

  appFormids: string;

  appIcon: string;

  appDicids: string;

  appDblinkids: string;

  appBillcodeids: string;

  appRemark: string;
}

/**
 * @description: XjrMyapp分页返回值模型
 */
export interface XjrMyappPageModel {
  id: string;

  appName: string;

  appCode: string;

  appType: string;

  appVersion: string;

  appCodetype: string;

  appRemark: string;

  appPicture: string;

  appInterfaceids: string;

  appFormId: {
    formType: number;
    key: string;
    formId: string;
    formName: string;
  };

  appIcon: string;

  appDesktopId: {
    formType: number;
    code: string;
    name: string;
    img: string;
  };

  appDblinkids: string;

  appBiId: {
    formType: number;
    code: string;
    name: string;
    img: string;
  };
  appData: {
    id: string;
    name: string;
  };
}

0;

/**
 * @description: XjrMyapp分页返回值结构
 */
export type XjrMyappPageResult = BasicFetchResult<XjrMyappPageModel>;
