import {
  MesWarehouseChgapplyModel,
  MesWarehouseChgapplyPageParams,
  MesWarehouseChgapplyPageResult,
} from './model/WarehouseChgAppModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/warehousechgapp/page',
  List = '/mes/warehousechgapp/list',
  Info = '/mes/warehousechgapp/info',
  MesWarehouseChgapply = '/mes/warehousechgapp',

  Export = '/mes/warehousechgapp/export',
}

/**
 * @description: 查询MesWarehouseChgapply分页列表
 */
export async function getMesWarehouseChgapplyPage(
  params: MesWarehouseChgapplyPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesWarehouseChgapplyPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseChgapply信息
 */
export async function getMesWarehouseChgapply(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseChgapplyModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseChgapply
 */
export async function addMesWarehouseChgapply(
  mesWarehouseChgapply: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseChgapply,
      params: mesWarehouseChgapply,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseChgapply
 */
export async function updateMesWarehouseChgapply(
  mesWarehouseChgapply: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseChgapply,
      params: mesWarehouseChgapply,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 确认提交
 */
export async function deleteMesWarehouseChgapply(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseChgapply,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function finishMesWarehouseChgapply(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: '/mes/warehousechgapp/finish/' + id,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 导出MesWarehouseChgapply
 */
export async function exportMesWarehouseChgapply(
  params?: object,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
