import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProductSetup分页参数 模型
 */
export interface MesProductSetupPageParams extends BasicPageParams {
  setupType: string;

  name: string;

  state: string;
}

/**
 * @description: MesProductSetup分页返回值模型
 */
export interface MesProductSetupPageModel {
  id: string;

  setupType: string;

  name: string;

  state: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProductSetup表类型
 */
export interface MesProductSetupModel {
  id: number;

  setupType: string;

  code: string;

  name: string;

  state: number;

  sort: number;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProductSetup分页返回值结构
 */
export type MesProductSetupPageResult = BasicFetchResult<MesProductSetupPageModel>;