import {
  MesQbCheckmethodModel,
  MesQbCheckmethodPageParams,
  MesQbCheckmethodPageResult,
} from './model/MescheckmethodModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mescheckmethod/page',
  List = '/mes/mescheckmethod/list',
  Info = '/mes/mescheckmethod/info',
  MesQbCheckmethod = '/mes/mescheckmethod',
}

/**
 * @description: 查询MesQbCheckmethod分页列表
 */
export async function getMesQbCheckmethodPage(
  params: MesQbCheckmethodPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesQbCheckmethodPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbCheckmethod信息
 */
export async function getMesQbCheckmethod(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbCheckmethodModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbCheckmethod
 */
export async function addMesQbCheckmethod(
  mesQbCheckmethod: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbCheckmethod,
      params: mesQbCheckmethod,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbCheckmethod
 */
export async function updateMesQbCheckmethod(
  mesQbCheckmethod: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbCheckmethod,
      params: mesQbCheckmethod,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbCheckmethod（批量删除）
 */
export async function deleteMesQbCheckmethod(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbCheckmethod,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
