import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'dataCode',
    label: '盘点编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataDate',
    label: '盘点日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'dataName',
    label: '盘点主题',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataStorage',
    label: '盘点仓库',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getWarehouseList',
        method: 'GET',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              { bindType: 'value', required: false, name: 'data_type', value: '0' },
              {
                dataType: 'String',
                bindType: '',
                required: false,
                name: 'warehouse_id',
                value: '',
              },
              { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'dataUser',
    label: '盘点人员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createDate',
    label: '创建时间',
    component: 'RangePicker',
    componentProps: {
      showTime: true,
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'dataCode',
    title: '盘点编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'dataDate',
    title: '盘点日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'dataName',
    title: '盘点主题',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'dataStorage',
    title: '盘点仓库',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'products',
    title: '物品摘要',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'dataUser',
    title: '盘点人员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'aaa702bb9c6c43e9bcdf59948bdaf060',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'c317aad036c8422ba088fee9b2c6e93e',
      field: 'dataCode',
      label: '盘点编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '盘点编号盘点编号请输入编码组件',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'meswarehouseCheckNo',
        required: true,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: '184c0d8c773b46fb9b49a141f24a3fc5',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: false,
        disabled: false,
        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "const code='dataCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: 'f613107c60ba4c93b8b096108a317ca9',
      field: 'dataDate',
      label: '盘点日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '盘点日期请选择',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'b115b7ae63be4efc9c60f1a7952e6ba6',
      field: 'dataName',
      label: '盘点主题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入盘点主题',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '8c13d64a8e1840b0874e994f9176dc3c',
      field: 'dataStorage',
      label: '盘点仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getWarehouseList',
          method: 'GET',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '0' },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'warehouse_id',
                  value: '',
                },
                { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'd623cc43dec0455b8c98660bdf2e637b',
      field: 'dataUser',
      label: '盘点人员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择盘点人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: false,
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '9f55e8350b3a457b877eedfcd2a511fd',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '163ca8e5d145471c87d392556ad121db',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '物品明细',
      componentProps: {
        defaultValue: '物品明细',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '8a23053744b942ce8d8d199b1c1569c3',
      label: '',
      field: 'mesWarehouseCheckDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesWarehouseCheckDetailList',
        columns: [
          {
            key: 'eee3093b6f8e467d936b48efcc69eb29',
            title: '物品编码',
            dataIndex: 'productId',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              width: '100%',
              span: '',
              placeholder: '请选择物品编码',
              showLabel: true,
              disabled: false,
              datasourceType: 'api',
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getMaterialListByCheck',
                method: 'GET',
                apiId: 'copy1691116544397d71330',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'keyword',
                        value: null,
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'showLabel',
                        value: 'code',
                        description: '回显字段：code/name',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: 'name',
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
                outputParams: [
                  {
                    name: 'code',
                    tableTitle: '物品编码',
                    bindField: 'product_no',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'name',
                    tableTitle: '物品名称',
                    bindField: 'product_name',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'model',
                    tableTitle: '规格型号',
                    bindField: 'spe_model',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'type_name',
                    tableTitle: '类型',
                    bindField: 'de_type',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'unit_id',
                    tableTitle: '单位',
                    bindField: 'unity',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'sys_count',
                    tableTitle: '系统数量',
                    bindField: 'sys_num',
                    show: true,
                    width: 150,
                  },
                ],
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'dd232ffeef5c4a05a500165ae1e824d9',
            title: '物品编码-隐藏',
            dataIndex: 'productNo',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物品编码-隐藏-隐藏',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '8765f3697a6f4821a6212af437d4f211',
            title: '物品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物品名称',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '0e8d5f2d2aac4c5797e7688128c72133',
            title: '规格型号',
            dataIndex: 'speModel',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入规格型号',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '83263601af294f8987d360bf7e299391',
            title: '类型',
            dataIndex: 'deType',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入类型',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'ee99236b6f094d93bbe296fc882de364',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入单位',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '1a201f7da4d148c8935f10cef6251295',
            title: '系统数量',
            dataIndex: 'sysNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '系统数量请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'e0ddcd8fbd534c9991339ab6ecdcc3a9',
            title: '实际数量',
            dataIndex: 'realNum',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: true,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'b5445b462b0e44d399d555bdaf717174',
            title: '盈亏数量',
            dataIndex: 'lostNum',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'b8a89cfd36024592bd68f19fa51f59ab',
            title: '盘点结果',
            dataIndex: 'checkResult',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: '正常', value: '1' },
                { key: 2, label: '盘赢', value: '2' },
                { key: 3, label: '盘亏', value: '3' },
              ],
              defaultSelect: '1',
              datasourceType: 'staticData',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {},
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '45c36907d9a546e4ac6422110bcd995d',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入备注',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: '32fe7102635a4a1ebc9fdd02c439eb2c',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '附件',
      componentProps: { defaultValue: '附件', color: '', align: 'left', fontSize: 15, style: {} },
    },
    {
      key: 'd07d87ffeaec4911bd1ad8d9c1b55aaa',
      field: 'dataFile',
      label: '上传组件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: false,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
      },
    },
    {
      key: 'e656a4a844394a66aa812f485e864449',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: '29dfe7cc94aa4e4ba514114c78a60e2d',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 2,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
