import { GeneratorConfig } from '/@/model/generator/generatorConfig';
import { ColumnType, TableInfo } from '/@/model/generator/tableInfo';

export const generatorConfig: GeneratorConfig = {
  databaseId: '',
  formJson: {
    list: [],
    config: {},
  },
  listConfig: {
    buttonConfigs: [
      {
        code: '',
        name: '',
        icon: '',
      },
    ],
    columnConfigs: [
      {
        label: '字符串',
        alignType: 'center',
        columnName: 'field_string',
        columnWidth: '20',
      },
      {
        label: '数字',
        alignType: 'center',
        columnName: 'field_long',
        columnWidth: '20',
      },
      {
        label: '整型',
        alignType: 'center',
        columnName: 'field_int',
        columnWidth: '20',
      },
      {
        label: '浮点',
        alignType: 'center',
        columnName: 'field_double',
        columnWidth: '20',
      },
      {
        label: '时间',
        alignType: 'center',
        columnName: 'field_datetime',
        columnWidth: '20',
      },
    ],
    isLeftMenu: true,
    isPage: true,
    isAdvancedQuery: false, //是否配置高级搜索
    leftMenuConfig: [
      {
        childIcon: '',
        dataSourceId: '0',
        datasourceType: 'api',
        dictionaryItemId: '0',
        fieldName: '',
        isDictionary: true,
        // isTree: true,
        leftWidth: 1,
        menuName: '',
        parentFiledName: '',
        parentIcon: '',
        showFieldName: '',
        apiConfig: {},
        staticData: [],
      },
    ],
    orderBy: '',
    orderType: 'desc',
    queryConfigs: [
      {
        fieldName: 'field_string',
        label: 'q1',
      },
      {
        fieldName: 'field_datetime',
        label: 'q2',
      },
      {
        fieldName: 'field_int',
        label: 'q3',
      },
    ],
    totalConfigs: [
      {
        fieldName: '',
      },
    ],
  },
  menuConfig: {
    code: 'xx',
    icon: 'xx',
    name: 'xx',
    parentId: '',
    remark: 'xxx',
    sortCode: 0,
  },
  outputConfig: {
    className: 'demo',
    comment: 'xx',
    creator: 'xx',
    onlyInterface: true,
    onlyFront: true,
    outputArea: 'bi',
    isApp: true,
    isMenu: false,
  },
  tableConfigs: [
    {
      isMain: true,
      pkField: 'id',
      relationField: '',
      tableName: 'demo',
      relationTableField: '',
    },
  ],
};

export const tableInfo: TableInfo[] = [
  {
    tableName: 'demo',
    columnInfo: [
      {
        columnName: 'id',
        columnType: ColumnType.NUMBER,
        columnLength: '',
        isPrimaryKey: true,
        isNullable: false,
      },
      {
        columnName: 'field_string',
        columnType: ColumnType.STRING,
        columnLength: '50',
        isPrimaryKey: false,
        isNullable: true,
      },
      {
        columnName: 'field_int',
        columnType: ColumnType.NUMBER,
        columnLength: '50',
        isPrimaryKey: false,
        isNullable: true,
      },
      {
        columnName: 'field_double',
        columnType: ColumnType.NUMBER,
        columnLength: '50',
        isPrimaryKey: false,
        isNullable: true,
      },
      {
        columnName: 'field_long',
        columnType: ColumnType.NUMBER,
        columnLength: '50',
        isPrimaryKey: false,
        isNullable: true,
      },
      {
        columnName: 'field_datetime',
        columnType: ColumnType.STRING,
        columnLength: '50',
        isPrimaryKey: false,
        isNullable: true,
      },
    ],
  },
];
