import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: CaseErpApply分页参数 模型
 */
export interface CaseErpApplyPageParams extends BasicPageParams {
  applyNumber: string;

  isSysNum: string;

  theme: string;

  applyDateStart: string;
  applyDateEnd: string;

  applyUserIds: string;

  applyDepId: string;

  relatedProject: string;

  remark: string;
}

/**
 * @description: CaseErpApply分页返回值模型
 */
export interface CaseErpApplyPageModel {
  id: string;

  applyNumber: string;

  isSysNum: string;

  theme: string;

  applyDate: string;

  applyUserIds: string;

  applyDepId: string;

  relatedProject: string;

  remark: string;
}

/**
 * @description: CaseErpApply表类型
 */
export interface CaseErpApplyModel {
  id: number;

  applyNumber: string;

  theme: string;

  applyDate: string;

  applyDepId: number;

  applyDepName: string;

  applyUserIds: string;

  applyUserNames: string;

  relatedProject: number;

  remark: string;

  countSum: number;

  amountSum: number;

  filePath: string;

  isSysNum: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  caseErpApplyDetailList?: CaseErpApplyDetailModel[];
}

/**
 * @description: CaseErpApplyDetail表类型
 */
export interface CaseErpApplyDetailModel {
  id: number;

  applyId: number;

  code: string;

  name: string;

  model: string;

  unitName: string;

  price: number;

  count: number;

  amount: number;

  payDate: string;

  purpose: string;

  remark: string;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: CaseErpApply分页返回值结构
 */
export type CaseErpApplyPageResult = BasicFetchResult<CaseErpApplyPageModel>;
