import {
  MesProOrderModel,
  MesProOrderPageParams,
  MesProOrderPageResult,
} from './model/ProOrderModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proorder/page',
  List = '/mes/proorder/list',
  Info = '/mes/proorder/info',
  MesProOrder = '/mes/proorder',
}

/**
 * @description: 查询MesProOrder分页列表
 */
export async function getMesProOrderPage(
  params: MesProOrderPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProOrderPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrder信息
 */
export async function getMesProOrder(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrder
 */
export async function addMesProOrder(mesProOrder: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrder,
      params: mesProOrder,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrder
 */
export async function updateMesProOrder(mesProOrder: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrder,
      params: mesProOrder,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrder（批量删除）
 */
export async function deleteMesProOrder(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrder,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function cancelMesProOrder(
  ids: string,
  rmk: string,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: '/mes/proorder/cancel/' + ids + '/',
      params: { rmk: rmk },
    },
    {
      errorMessageMode: mode,
    },
  );
}
