import {
  MesDevRepairModel,
  MesDevRepairPageParams,
  MesDevRepairPageResult,
} from './model/DevRepairModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/devrepair/page',
  List = '/mes/devrepair/list',
  Info = '/mes/devrepair/info',
  MesDevRepair = '/mes/devrepair',

  Export = '/mes/devrepair/export',
}

/**
 * @description: 查询MesDevRepair分页列表
 */
export async function getMesDevRepairPage(
  params: MesDevRepairPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesDevRepairPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesDevRepair信息
 */
export async function getMesDevRepair(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesDevRepairModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesDevRepair
 */
export async function addMesDevRepair(mesDevRepair: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesDevRepair,
      params: mesDevRepair,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesDevRepair
 */
export async function updateMesDevRepair(
  mesDevRepair: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesDevRepair,
      params: mesDevRepair,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesDevRepair（批量删除）
 */
export async function deleteMesDevRepair(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesDevRepair,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesDevRepair
 */
export async function exportMesDevRepair(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
