import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  CollectionPageListSearchModel,
  CollectionPageListResultModel,
  CollectionAddParamsModel,
  CollectionUpdateParamsModel,
  CollectionDetailAddParamsModel,
  CollectionDetailUpdateParamsModel,
  CollectionDetailInfoModel,
} from './model';

enum Api {
  Page = '/caseErpCustomer/caseErpCustomerGather/page',
  Info = '/caseErpCustomer/caseErpCustomerGather/info',
  Collection = '/caseErpCustomer/caseErpCustomerGather',
  CollectionDetail = '/caseErpCustomer/caseErpCustomerGatherDetail',
  DetailInfo = '/caseErpCustomer/caseErpCustomerGather/gather-detail-info',
  CollectionDetailInfo = '/caseErpCustomer/caseErpCustomerGatherDetail/info',
}

/**
 * @description: 查询回款列表（分页）
 */
export async function getCollectionPageList(
  params: CollectionPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<CollectionPageListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增回款
 */
export async function addCollection(
  params: CollectionAddParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.Collection,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改回款
 */
export async function updateCollection(
  params: CollectionUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Collection,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除回款
 */
export async function deleteCollection(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Collection,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询回款详情
 */
export async function getCollectionInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CollectionAddParamsModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增回款记录详情
 */
export async function addCollectionDetail(
  params: CollectionDetailAddParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.CollectionDetail,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改回款记录详情
 */
export async function updateCollectionDetail(
  params: CollectionDetailUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.CollectionDetail,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除回款记录详情
 */
export async function deleteCollectionDetail(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.CollectionDetail,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查看回款记录列表详情
 */
export async function getDetailInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CollectionDetailInfoModel>(
    {
      url: Api.DetailInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查看回款记录单条详情
 */
export async function getCollectionDetailInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CollectionDetailAddParamsModel>(
    {
      url: Api.CollectionDetailInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}
