
import { RokeStockPickingTypePageModel, RokeStockPickingTypePageParams, RokeStockPickingTypePageResult } from './model/ZylxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/zylx/page',
  List = '/jcsj/zylx/list',
  Info = '/jcsj/zylx/info',
  RokeStockPickingType = '/jcsj/zylx',
  
  
  
}

/**
 * @description: 查询RokeStockPickingType分页列表
 */
export async function getRokeStockPickingTypePage(params: RokeStockPickingTypePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeStockPickingTypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeStockPickingType信息
 */
export async function getRokeStockPickingType(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeStockPickingTypePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeStockPickingType
 */
export async function addRokeStockPickingType(rokeStockPickingType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeStockPickingType,
      params: rokeStockPickingType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeStockPickingType
 */
export async function updateRokeStockPickingType(rokeStockPickingType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeStockPickingType,
      params: rokeStockPickingType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeStockPickingType（批量删除）
 */
export async function deleteRokeStockPickingType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeStockPickingType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




