
import { MesWorkTeamPageModel, MesWorkTeamPageParams, MesWorkTeamPageResult } from './model/TeamManagementModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/teammanagement/page',
  List = '/jcsj/teammanagement/list',
  Info = '/jcsj/teammanagement/info',
  MesWorkTeam = '/jcsj/teammanagement',
  
  
  
}

/**
 * @description: 查询MesWorkTeam分页列表
 */
export async function getMesWorkTeamPage(params: MesWorkTeamPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWorkTeamPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWorkTeam信息
 */
export async function getMesWorkTeam(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWorkTeamPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWorkTeam
 */
export async function addMesWorkTeam(mesWorkTeam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWorkTeam,
      params: mesWorkTeam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWorkTeam
 */
export async function updateMesWorkTeam(mesWorkTeam: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWorkTeam,
      params: mesWorkTeam,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWorkTeam（批量删除）
 */
export async function deleteMesWorkTeam(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWorkTeam,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




