
import { MesHegezhengPageModel, MesHegezhengPageParams, MesHegezhengPageResult } from './model/HgzglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/hgzgl/page',
  List = '/jcsj/hgzgl/list',
  Info = '/jcsj/hgzgl/info',
  MesHegezheng = '/jcsj/hgzgl',
  
  
  
}

/**
 * @description: 查询MesHegezheng分页列表
 */
export async function getMesHegezhengPage(params: MesHegezhengPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesHegezhengPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesHegezheng信息
 */
export async function getMesHegezheng(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesHegezhengPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesHegezheng
 */
export async function addMesHegezheng(mesHegezheng: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesHegezheng,
      params: mesHegezheng,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesHegezheng
 */
export async function updateMesHegezheng(mesHegezheng: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesHegezheng,
      params: mesHegezheng,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesHegezheng（批量删除）
 */
export async function deleteMesHegezheng(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesHegezheng,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




