
import { MesWarehouseOtherPageModel, MesWarehouseOtherPageParams, MesWarehouseOtherPageResult } from './model/QtrkModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/qtrk/page',
  List = '/ckgl/qtrk/list',
  Info = '/ckgl/qtrk/info',
  MesWarehouseOther = '/ckgl/qtrk',
  
  
  Export = '/ckgl/qtrk/export',
  
}

/**
 * @description: 查询MesWarehouseOther分页列表
 */
export async function getMesWarehouseOtherPage(params: MesWarehouseOtherPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseOtherPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseOther信息
 */
export async function getMesWarehouseOther(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseOtherPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseOther
 */
export async function addMesWarehouseOther(mesWarehouseOther: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseOther,
      params: mesWarehouseOther,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseOther
 */
export async function updateMesWarehouseOther(mesWarehouseOther: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseOther,
      params: mesWarehouseOther,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseOther（批量删除）
 */
export async function deleteMesWarehouseOther(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseOther,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesWarehouseOther
 */
export async function exportMesWarehouseOther(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

