import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'reportNo',
    label: '报告编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportName',
    label: '报告抬头',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'checkDate',
    label: '检验日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'checkUser',
    label: '检验员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'errorState',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1686656230883135490' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'samplingStandard',
    label: '抽样标准',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getCheckStandard',
        method: 'GET',
        apiId: '6967f0799cec4087bbfacae79faa0606',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script: '',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'samplingNum',
    label: '抽样数',
    component: 'InputNumber',
    componentProps: {
      style: { width: '100%' },
    },
    colProps: { span: 8 },
  },
  {
    field: 'chekcType',
    label: '检测类别',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checktype where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckType',
        apiId: '7142de95ccfe43cb8beffe37a62474d2',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkProduct',
    label: '检测项目',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckProduct',
        apiId: '662ac83978054327a0947126993b1175',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkStandard',
    label: '检验标准',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckStandard',
        apiId: '6967f0799cec4087bbfacae79faa0606',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'checkMethod',
    label: '检验方法',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkmethod where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckmethod',
        apiId: 'c84aa22dc1f946c284b716bdfaf0b6f1',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'createDate',
  //   label: '报告生成日期',
  //   component: 'RangePicker',
  //   componentProps: {
  //     showTime: true,
  //     style: { width: '100%' },
  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },

  {
    field: 'judgeResult',
    label: '整体判定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'remark',
  //   label: '备注',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'reportNo',
    title: '报告编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '报告抬头',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'samplingStandard',
    title: '抽样标准',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'samplingNum',
    title: '抽样数',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'chekcType',
    title: '检测类别',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'checkProduct',
    title: '检测项目',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'checkStandard',
    title: '检验标准',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'checkMethod',
    title: '检验方法',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '整体判定',
    componentType: 'radio',

    customRender: ({ record }) => {
      const staticOptions = [
        { label: '合格', value: '1', key: 1 },
        { label: '不合格', value: '2', key: 2 },
      ];
      return staticOptions.filter((x) => x.value === record.judgeResult)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'checkUser',
    title: '检验员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'checkDate',
    title: '检验日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '报告生成日期',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'c6a4b79c05bc4e488a6605ec02a2ed20',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9b416ca82c774e40bfbc78426c0df44f',
      field: 'reportNo',
      label: '报告编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '报告编号请输入报告编号',
        addonBefore: '',
        autoCodeRule: 'mesFinishReportNo',
        span: null,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: '6cb7245519ad4c528774a387224f57ae',
      field: 'isSysNum',
      label: '多选组件',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: null,
        showLabel: false,
        disabled: false,
        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "const code='reportNo';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: '1decf8cad9d244898045f1e143b540e4',
      field: 'checkDate',
      label: '检验日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择检验日期',
        allowClear: true,
        events: {},
        span: null,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '5e872d8d13a84b7c965275e705233133',
      field: 'reportName',
      label: '报告抬头',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入报告抬头',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: null,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '383b830b621c4a5c97367f8c7d7ac3b6',
      field: 'checkUser',
      label: '检验员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: true,
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'b4cc9ce761d64fe9a8393ce882c73e4a',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测配置',
      componentProps: {
        defaultValue: '检测配置',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'f159683530b94b0da526da91fc8fa3e7',
      field: 'samplingStandard',
      label: '抽样标准',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        itemId: '1687016394928754690',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择抽样标准',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '754f0b70872a4bba8affab1e76ba4490',
      field: 'samplingNum',
      label: '抽样数',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: null,
      componentProps: {
        width: '100%',
        span: null,
        defaultValue: null,
        min: 0,
        //max: 100
        step: 1,
        maxlength: null,
        disabled: false,
        showLabel: true,
        controls: true,
        required: false,
        subTotal: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '48b5c116914f4efe95ca6be73e2b612c',
      field: 'chekcType',
      label: '检测类别',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        mode: 'multiple', //多选
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checktype where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckType',
          apiId: '7142de95ccfe43cb8beffe37a62474d2',
        },
        disabled: false,
        placeholder: '请选择检测类别',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '2c89f53cc0034c6b83f4bd4ff36c6d1e',
      field: 'checkProduct',
      label: '检测项目',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        mode: 'multiple', //多选
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkproduct where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckProduct',
          apiId: '662ac83978054327a0947126993b1175',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'eb29a09f5060470e89c2fc981c1d31ef',
      field: 'checkStandard',
      label: '检验标准',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        mode: 'multiple', //多选
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择检验标准',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '7bda7875922d487b8c4a780299be838a',
      field: 'checkMethod',
      label: '检验方法',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        mode: 'multiple', //多选
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkmethod where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckmethod',
          apiId: 'c84aa22dc1f946c284b716bdfaf0b6f1',
        },
        disabled: false,
        placeholder: '请选择检验方法',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'e3034eec7fec40f48967f8459b45fb02',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: null,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'be92f7030f214b66aea1e7616dd52790',
      field: 'createDate',
      label: '报告生成日期',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: null,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '11a6d169e6eb4741a2109fb73fdcb169',
      field: 'errorState',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'name',
        datasourceType: 'dic',
        itemId: '1686656230883135490',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: true,
        placeholder: '',
        staticOptions: [
          { label: '待发起', value: '0', key: 1 },
          { label: '审核中', value: '1', key: 2 },
          { label: '审核通过', value: '8', key: 3 },
          { key: 4, label: '审核不通过', value: '9' },
        ],
        events: {},
        span: '',
        params: { itemId: '1686656230883135490' },
        style: { width: '100%' },
      },
    },
    {
      key: '1e7776fb21dd4253a1ceffd9f2e41495',
      label: '',
      field: 'mesQbFinishDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQbFinishDetailList',
        columns: [
          {
            key: '755fc8b5f7854e61a2cdc766f52b6403',
            title: '工单编号',
            dataIndex: 'workNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'work_no',
            },
          },
          {
            key: '33161deb267046df8cc391407e92379f',
            title: '销售单ID',
            dataIndex: 'saleId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'sale_order_id',
            },
          },
          {
            key: '494f292a690e4b8eb82595619b7e77d5',
            title: '销售订单号',
            dataIndex: 'saleNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'sale_order_no',
            },
          },
          {
            key: '21e503bea06f40598c4ba6dcd3159da0',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'material_id',
            },
          },
          {
            key: 'cfb0a63929614b21b390d4af63b79365',
            title: '物料编号',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'material_no',
            },
          },
          {
            key: '3178e0e138214161991a0f0878f0883d',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: true,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
              prestrainField: 'material_name',
            },
          },
          {
            key: '328ad6a3a1fa445bb52167bf43750412',
            title: '车间',
            dataIndex: 'carId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '1',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'car_id',
            },
          },
          {
            key: '30a628cffbaa44129de72c6fb39f2658',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              controls: true,
              //max: 100,
              defaultValue: null,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: '044b7fcda71740e4b43e4d0dd93f6cbb',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              controls: true,
              //max: 100,
              defaultValue: null,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'e624df8ee19d401581dc790092707995',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              controls: true,
              //max: 100,
              defaultValue: null,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: false,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
            },
          },
          {
            key: 'f348d3a418994ab8982af2e0a7179b0c',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'e79e65a40cd34106a96a65d4fd88d5ff',
            title: '不良数',
            dataIndex: 'errorNum',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '5cdc24627ab74026b342242494724b76',
            title: '不良处理方式',
            dataIndex: 'errorMethod',
            componentType: 'Input',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '1395b1af977a4b3ba1f2dca17c13ddc6',
            dataIndex: 'imgFile',
            title: '上传',
            componentType: 'Upload',
            componentProps: {
              api: uploadApi,
              span: '',
              defaultValue: [],
              accept: '',
              maxNumber: 5,
              maxSize: 5,
              showLabel: true,
              multiple: false,
              disabled: false,
              required: false,
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '新增',
        showIndex: true,
        useSelectButton: true,
        useCopyButton: true,
        useResetButton: true,
        useAddButton: false, //不显示新增按钮
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {
          path: '/mes/getWorkOrderList',
          method: 'GET',
          apiId: 'copy1690957970852d38383',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'state',
                  value: '8',
                  description: '状态0-待下发、1-待生产、2-生产中，8-已完成、9已关闭、7已暂停',
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'material_type',
                  value: '成品',
                  description: '物料类别',
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nif(material_type!=null&&material_type!=""){ \r\n    condition+=" and material_type=#{material_type}";\r\n}\r\nif(state!=null&&state!=""){ \r\n    condition+=" and state=#{state}";\r\n}else{\r\n     condition+=" and state=8";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.work_no AS label,t.* FROM mes_pro_orderwork t where 1=1  "+condition)',
          outputParams: [
            { tableTitle: '工单编号', name: 'work_no' },
            { tableTitle: '物料编码', name: 'material_no' },
            { tableTitle: '物料名称', name: 'material_name' },
            { tableTitle: '销售订单号', name: 'sale_order_no' },
            { tableTitle: '车间', name: 'car_name' },
          ],
        },
        showFormBorder: true,
        span: '24',
      },
    },
    {
      key: '5e1afb160a374e5a8a391b0c0d055914',
      field: 'checkreportNo',
      label: '检测报告编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '检测报告编号请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '17dc8a1665944b92aeec505dff9234a4',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '检测结果',
      componentProps: {
        defaultValue: '检测结果',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0ea4188a4e3d4d1c95e6498ae1d10127',
      field: 'judgeResult',
      label: '整体判定',
      type: 'radio',
      component: 'ApiRadioGroup',
      colProps: { span: 22 },
      ifShow: true,
      componentProps: {
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        optionType: 'default',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [
          { label: '合格', value: '1', key: 1 },
          { label: '不合格', value: '2', key: 2 },
        ],
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'resetBtn1',
      field: '',
      label: '按钮组件',
      type: 'button',
      component: 'Button',
      colProps: { span: 2 },
      componentProps: {
        name: '重置',
        buttonWidth: '',
        buttonHeight: '',
        prefix: '',
        suffix: '',
        disabled: false,
        events: { click: "formModel.judgeResult='';" },
        width: '',
        height: '',
      },
    },
    {
      key: '5e8cbb4d3b76447a9df98987ada7cdf1',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
