import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'parentId',
    label: '所属上级',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataCode',
    label: '仓库编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataName',
    label: '仓库名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  // {
  //   field: 'warehouseType',
  //   label: '仓库类型',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       method: 'GET',
  //       script:
  //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_warehousetype where state=1 "+condition)',
  //       apiParams: [
  //         { tableInfo: [], title: 'Query Params', key: '1' },
  //         { tableInfo: [], title: 'Header', key: '2' },
  //         { title: 'Body', key: '3' },
  //       ],
  //       path: '/mes/getWarehousetypeList',
  //       apiId: 'copy1690444411320d33169',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'areaType',
  //   label: '库区分类',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       method: 'GET',
  //       script:
  //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_areatype where state=1 "+condition)',
  //       apiParams: [
  //         { tableInfo: [], title: 'Query Params', key: '1' },
  //         { tableInfo: [], title: 'Header', key: '2' },
  //         { title: 'Body', key: '3' },
  //       ],
  //       path: '/mes/getAreatypeList',
  //       apiId: 'copy1690444582581d95888',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'warehouseId',
  //   label: '所属仓库',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       method: 'GET',
  //       script:
  //         'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
  //       apiParams: [
  //         {
  //           tableInfo: [
  //             { bindType: 'value', required: false, name: 'data_type', value: '0' },
  //             { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
  //             { bindType: 'value', required: false, name: 'area_id', value: '' },
  //           ],
  //           title: 'Query Params',
  //           key: '1',
  //         },
  //         { tableInfo: [], title: 'Header', key: '2' },
  //         { title: 'Body', key: '3' },
  //       ],
  //       path: '/mes/getWarehouseList',
  //       apiId: 'd5acd359b8c6490caa8291712d2a2127',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'areaId',
  //   label: '所属库区',
  //   component: 'XjrSelect',
  //   componentProps: {
  //     datasourceType: 'api',
  //     apiConfig: {
  //       method: 'GET',
  //       script:
  //         'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
  //       apiParams: [
  //         {
  //           tableInfo: [
  //             { bindType: 'value', required: false, name: 'data_type', value: '1' },
  //             { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
  //             { bindType: 'value', required: false, name: 'area_id', value: '' },
  //           ],
  //           title: 'Query Params',
  //           key: '1',
  //         },
  //         { tableInfo: [], title: 'Header', key: '2' },
  //         { title: 'Body', key: '3' },
  //       ],
  //       path: '/mes/getWarehouseList',
  //       apiId: 'd5acd359b8c6490caa8291712d2a2127',
  //     },
  //     labelField: 'label',
  //     valueField: 'value',

  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'manages',
  //   label: '仓库负责人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'address',
  //   label: '仓库地址',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
  // {
  //   field: 'state',
  //   label: '仓库状态',
  //   component: 'Select',
  //   componentProps: {
  //     getPopupContainer: () => document.body,
  //     options: [
  //       {
  //         label: '开',
  //         value: 1,
  //       },
  //       {
  //         label: '关',
  //         value: 0,
  //       },
  //     ],
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createUserId',
  //   label: '创建人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createDate',
  //   label: '创建时间',
  //   component: 'RangePicker',
  //   componentProps: {
  //     showTime: true,
  //     style: { width: '100%' },
  //     getPopupContainer: () => document.body,
  //   },
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'dataCode',
    title: '仓库编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'dataName',
    title: '仓库名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'warehouseType',
    title: '仓库类型',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'manages',
    title: '仓库负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '仓库状态',
    componentType: 'switch',

    sorter: true,
  },
  {
    dataIndex: 'address',
    title: '仓库地址',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];
export const columns1: BasicColumn[] = [
  {
    dataIndex: 'dataCode',
    title: '库区编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'dataName',
    title: '库区名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'areaType',
    title: '库区分类',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'warehouseId',
    title: '所属仓库',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'manages',
    title: '库区负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '仓库状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];
export const columns2: BasicColumn[] = [
  {
    dataIndex: 'dataCode',
    title: '库位编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'dataName',
    title: '库位名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'warehouseId',
    title: '所属仓库',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'areaId',
    title: '所属库区',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '库位状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    // {
    //   key: 'e870d216ef364c6ca4957b0f66e8ae84',
    //   field: 'parentId',
    //   label: '所属上级',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     width: '100%',
    //     span: '',
    //     defaultValue: '',
    //     placeholder: '请输入所属上级',
    //     maxlength: null,
    //     prefix: '',
    //     suffix: '',
    //     addonBefore: '',
    //     addonAfter: '',
    //     disabled: false,
    //     allowClear: false,
    //     showLabel: true,
    //     required: false,
    //     rules: [],
    //     events: {},
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '61d1eada85354eadb04a00ba4d2f8677',
      field: 'dataCode',
      label: '仓库编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入仓库编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '875c1e745a3b44868acb7e2726f464ee',
      field: 'dataName',
      label: '仓库名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入仓库名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '5badec1dc19041c381f95d2a7c5e6586',
      field: 'warehouseType',
      label: '仓库类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_warehousetype where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehousetypeList',
          apiId: 'copy1690444411320d33169',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: 'c224855c496841bf9856b3cd5cda4b2e',
    //   field: 'areaType',
    //   label: '库区分类',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_areatype where state=1 "+condition)',
    //       apiParams: [
    //         { tableInfo: [], title: 'Query Params', key: '1' },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getAreatypeList',
    //       apiId: 'copy1690444582581d95888',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '1a66e160c03c4c22913bcb412d5bbc48',
    //   field: 'warehouseId',
    //   label: '所属仓库',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
    //       apiParams: [
    //         {
    //           tableInfo: [
    //             { bindType: 'value', required: false, name: 'data_type', value: '0' },
    //             { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
    //             { bindType: 'value', required: false, name: 'area_id', value: '' },
    //           ],
    //           title: 'Query Params',
    //           key: '1',
    //         },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getWarehouseList',
    //       apiId: 'd5acd359b8c6490caa8291712d2a2127',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '0a19725e28b2406784643f6075463de2',
    //   field: 'areaId',
    //   label: '所属库区',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
    //       apiParams: [
    //         {
    //           tableInfo: [
    //             { bindType: 'value', required: false, name: 'data_type', value: '1' },
    //             { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
    //             { bindType: 'value', required: false, name: 'area_id', value: '' },
    //           ],
    //           title: 'Query Params',
    //           key: '1',
    //         },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getWarehouseList',
    //       apiId: 'd5acd359b8c6490caa8291712d2a2127',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '8c7b1c7e4db247259be548635081c2cd',
      field: 'manages',
      label: '仓库负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '10450233216f4e279d2b460625fc8026',
      field: 'address',
      label: '仓库地址',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入仓库地址',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'c2968088d5604f068cfbce138ba2bd95',
      field: 'sort',
      label: '仓库排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8aa5a7ae69b44b3eba7b74dc88cd46f4',
      field: 'state',
      label: '仓库状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    // {
    //   key: '21407113955d4319ae42b827a62ed9fe',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 0,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '1bd2f152cf714ac78c98ade12e80b84d',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 2,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formProps1: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    // {
    //   key: 'e870d216ef364c6ca4957b0f66e8ae84',
    //   field: 'parentId',
    //   label: '所属上级',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     width: '100%',
    //     span: '',
    //     defaultValue: '',
    //     placeholder: '请输入所属上级',
    //     maxlength: null,
    //     prefix: '',
    //     suffix: '',
    //     addonBefore: '',
    //     addonAfter: '',
    //     disabled: false,
    //     allowClear: false,
    //     showLabel: true,
    //     required: false,
    //     rules: [],
    //     events: {},
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '61d1eada85354eadb04a00ba4d2f8677',
      field: 'dataCode',
      label: '库区编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入库区编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '875c1e745a3b44868acb7e2726f464ee',
      field: 'dataName',
      label: '库区名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入库区名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '5badec1dc19041c381f95d2a7c5e6586',
    //   field: 'warehouseType',
    //   label: '仓库类型',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_warehousetype where state=1 "+condition)',
    //       apiParams: [
    //         { tableInfo: [], title: 'Query Params', key: '1' },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getWarehousetypeList',
    //       apiId: 'copy1690444411320d33169',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: 'c224855c496841bf9856b3cd5cda4b2e',
      field: 'areaType',
      label: '库区分类',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_areatype where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getAreatypeList',
          apiId: 'copy1690444582581d95888',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '1a66e160c03c4c22913bcb412d5bbc48',
      field: 'warehouseId',
      label: '所属仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '0' },
                { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
                { bindType: 'value', required: false, name: 'area_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehouseList',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '0a19725e28b2406784643f6075463de2',
    //   field: 'areaId',
    //   label: '所属库区',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
    //       apiParams: [
    //         {
    //           tableInfo: [
    //             { bindType: 'value', required: false, name: 'data_type', value: '1' },
    //             { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
    //             { bindType: 'value', required: false, name: 'area_id', value: '' },
    //           ],
    //           title: 'Query Params',
    //           key: '1',
    //         },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getWarehouseList',
    //       apiId: 'd5acd359b8c6490caa8291712d2a2127',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '8c7b1c7e4db247259be548635081c2cd',
      field: 'manages',
      label: '库区负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '10450233216f4e279d2b460625fc8026',
    //   field: 'address',
    //   label: '仓库地址',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     maxlength: 100,
    //     defaultValue: '',
    //     prefix: '',
    //     rules: [],
    //     suffix: '',
    //     addonAfter: '',
    //     showLabel: true,
    //     required: false,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请输入仓库地址',
    //     allowClear: false,
    //     addonBefore: '',
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: 'c2968088d5604f068cfbce138ba2bd95',
      field: 'sort',
      label: '库区排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8aa5a7ae69b44b3eba7b74dc88cd46f4',
      field: 'state',
      label: '库区状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    // {
    //   key: '21407113955d4319ae42b827a62ed9fe',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 0,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '1bd2f152cf714ac78c98ade12e80b84d',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 2,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formProps2: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    // {
    //   key: 'e870d216ef364c6ca4957b0f66e8ae84',
    //   field: 'parentId',
    //   label: '所属上级',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     width: '100%',
    //     span: '',
    //     defaultValue: '',
    //     placeholder: '请输入所属上级',
    //     maxlength: null,
    //     prefix: '',
    //     suffix: '',
    //     addonBefore: '',
    //     addonAfter: '',
    //     disabled: false,
    //     allowClear: false,
    //     showLabel: true,
    //     required: false,
    //     rules: [],
    //     events: {},
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '61d1eada85354eadb04a00ba4d2f8677',
      field: 'dataCode',
      label: '库位编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入库位编号',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '875c1e745a3b44868acb7e2726f464ee',
      field: 'dataName',
      label: '库位名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 100,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入库位名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '5badec1dc19041c381f95d2a7c5e6586',
    //   field: 'warehouseType',
    //   label: '仓库类型',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_warehousetype where state=1 "+condition)',
    //       apiParams: [
    //         { tableInfo: [], title: 'Query Params', key: '1' },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getWarehousetypeList',
    //       apiId: 'copy1690444411320d33169',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: 'c224855c496841bf9856b3cd5cda4b2e',
    //   field: 'areaType',
    //   label: '库区分类',
    //   type: 'select',
    //   component: 'XjrSelect',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     clearable: false,
    //     defaultSelect: '',
    //     rules: [],
    //     valueField: 'value',
    //     showLabel: true,
    //     required: true,
    //     labelField: 'label',
    //     datasourceType: 'api',
    //     dicOptions: [],
    //     showSearch: false,
    //     width: '100%',
    //     apiConfig: {
    //       method: 'GET',
    //       script:
    //         'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(code,\'-\',name) AS label FROM mes_base_areatype where state=1 "+condition)',
    //       apiParams: [
    //         { tableInfo: [], title: 'Query Params', key: '1' },
    //         { tableInfo: [], title: 'Header', key: '2' },
    //         { title: 'Body', key: '3' },
    //       ],
    //       path: '/mes/getAreatypeList',
    //       apiId: 'copy1690444582581d95888',
    //     },
    //     disabled: false,
    //     placeholder: '请选择',
    //     staticOptions: [
    //       { label: 'Option 1', value: 'Option 1', key: 1 },
    //       { label: 'Option 2', value: 'Option 2', key: 2 },
    //       { label: 'Option 3', value: 'Option 3', key: 3 },
    //     ],
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: '1a66e160c03c4c22913bcb412d5bbc48',
      field: 'warehouseId',
      label: '所属仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '0' },
                { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
                { bindType: 'value', required: false, name: 'area_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehouseList',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0a19725e28b2406784643f6075463de2',
      field: 'areaId',
      label: '所属库区',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS VALUE,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '1' },
                { bindType: 'value', required: false, name: 'warehouse_id', value: '' },
                { bindType: 'value', required: false, name: 'area_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehouseList',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
        },
        disabled: true,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    // {
    //   key: '8c7b1c7e4db247259be548635081c2cd',
    //   field: 'manages',
    //   label: '仓库负责人',
    //   type: 'user',
    //   component: 'User',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     defaultValue: '',
    //     prefix: '',
    //     suffix: 'ant-design:setting-outlined',
    //     showLabel: true,
    //     required: true,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请选择人员',
    //     userType: 0,
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '10450233216f4e279d2b460625fc8026',
    //   field: 'address',
    //   label: '仓库地址',
    //   type: 'input',
    //   component: 'Input',
    //   colProps: { span: 24 },
    //   defaultValue: '',
    //   componentProps: {
    //     maxlength: 100,
    //     defaultValue: '',
    //     prefix: '',
    //     rules: [],
    //     suffix: '',
    //     addonAfter: '',
    //     showLabel: true,
    //     required: false,
    //     width: '100%',
    //     disabled: false,
    //     placeholder: '请输入仓库地址',
    //     allowClear: false,
    //     addonBefore: '',
    //     events: {},
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    {
      key: 'c2968088d5604f068cfbce138ba2bd95',
      field: 'sort',
      label: '库位排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8aa5a7ae69b44b3eba7b74dc88cd46f4',
      field: 'state',
      label: '库位状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: '21407113955d4319ae42b827a62ed9fe',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '1bd2f152cf714ac78c98ade12e80b84d',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
