
import { MesBaseChejianPageModel, MesBaseChejianPageParams, MesBaseChejianPageResult } from './model/CjglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cjgl/page',
  List = '/jcsj/cjgl/list',
  Info = '/jcsj/cjgl/info',
  MesBaseChejian = '/jcsj/cjgl',
  
  
  
}

/**
 * @description: 查询MesBaseChejian分页列表
 */
export async function getMesBaseChejianPage(params: MesBaseChejianPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseChejianPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseChejian信息
 */
export async function getMesBaseChejian(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseChejianPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseChejian
 */
export async function addMesBaseChejian(mesBaseChejian: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseChejian,
      params: mesBaseChejian,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseChejian
 */
export async function updateMesBaseChejian(mesBaseChejian: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseChejian,
      params: mesBaseChejian,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseChejian（批量删除）
 */
export async function deleteMesBaseChejian(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseChejian,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




