import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface MaterialPageListParams {
  name?: string; //物料名称
  typeName?: string; //物料类别
  propertyName?: string; //物料属性
  state: number; //状态 0-关闭 1-开启
}

export interface MaterialAddParamsModel {
  classesId: string; //物料类别id
  code: string; //物料编码
  fileId: string; //图片路径
  isSysCodeBoolean: number; //是否系统编码
  model: string; //规格型号
  name: string; //物料名称
  propertyId: string; //物料属性id
  unitId: string; //单位id
  createUserName: string; //创建人
  createDate: string; //创建时间
  modifyDate: string; //修改时间
  modifyUserName: string; //修改人
  unitName: string; //单位名称
  typeName: string; //物料类别名称
  propertyName: string; //物料属性名称
}

export interface MaterialUpdateParamsModel {
  id: string; //详情id
  classesId: string; //物料类别id
  code: string; //物料编码
  fileId: string; //图片路径
  isSysCodeBoolean: number; //是否系统编码
  model: string; //规格型号
  name: string; //物料名称
  propertyId: string; //物料属性id
  unitId: string; //单位id
}

export interface MaterialListModel {
  id: string; //详情id
  code: string; //物料编码
  name: string; //物料名称
  model: string; //规格型号
  inventory: number; //当前库存
  unitName: string; //单位
  typeName: string; //物料类别
  propertyName: string; //物料属性
  state: number; //状态 0-关闭 1-开启
}

export interface PurchaseModel {
  number: string; //采购单号
  theme: string; //采购主题
  purchaseDate: string; //采购日期
  purchasePersonName: string; //采购人员
  purchaseDept: number; //采购部门
  supplierName: string; //供应商
  count: number; //采购数量
  accountSum: number; //采购金额
}

export interface InStoreModel {
  number: string; //入库单号
  theme: string; //入库主题
  date: string; //入库日期
  insertType: string; //入库类型
  count: number; //数量
  person: string; //入库人员
  store: number; //入库仓库
}

export interface OutStoreModel {
  number: string; //出库单号
  theme: string; //出库主题
  date: string; //出库日期
  outType: string; //出库类型
  count: number; //数量
  person: string; //出库人员
  store: number; //出库仓库
}

export interface LogModel {
  operateUserAccount: string; //操作人
  operateTime: string; //操作时间
  executeResultJson: string; //操作内容
}

export interface MaterialInfoParams {
  id: string; //id
  keyword?: string; //关键字
}

export interface MaterialStockParamsModel {
  id: string;
  count: number; //数量
  type: number; //-1：减少、1：增加、0：报废
  remark?: string;
}

export interface MaterialHistoryPageListParams {
  id: string; //详情id
  type?: string; //类型
}

export interface MaterialHistoryListModel {
  id: string; //详情id
  typeName: string; //库存类别
  name: string; //产品名称
  operateTypeName: string; //操作类型
  createDate: number; //操作时间
  count: number; //数量
  localInventory?: number; //库存结余
}

export type MaterialPageListSearchModel = BasicPageParams & MaterialPageListParams;
export type MaterialPageListResultModel = BasicFetchResult<MaterialListModel>;
export type MaterialHistoryPageListSearchModel = BasicPageParams & MaterialHistoryPageListParams;
export type MaterialHistoryPageListResultModel = BasicFetchResult<MaterialHistoryListModel>;
