import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'jhbh',
    label: '计划编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'ddbh',
    label: '订单编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'zt',
    label: '状态',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2004464883576217601' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'jhbh',
    title: '计划编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'ddbh',
    title: '订单编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'kh',
    title: '客户',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'jhjhrq',
    title: '计划交付日期',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zt',
    title: '状态',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
      isClick: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
      isClick: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'f7c021b2d5b544c684d0620a54c91f12',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'bb401260571f476c9816266b858aa2fa',
              field: 'jhbh',
              label: '计划编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入计划编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'cde76649b62b4db4a820c7fccfe2810c',
              field: 'khxmh',
              label: '客户项目号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入客户项目号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '253e91345aeb4346b0081560c11c9420',
              field: 'sfnbdd',
              label: '是否内部订单',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 2, label: '是', value: '1' },
                  { key: 3, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: 'option 1',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '0cad80076f6347b5966ef3d246d23165',
              field: 'ddbh',
              label: '订单编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入订单编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '7db6a62a09e347149a3110719726e010',
              field: 'jhjhrq',
              label: '计划交付日期',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择计划交付日期',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: 'c40beca261124a17b8ea5258ae8b1b82',
              field: 'jsyq',
              label: '技术要求',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: '',
                accept: '',
                maxNumber: 5,
                maxSize: '',
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
                sourceType: 'album,camera',
                tooltipConfig: { visible: false, title: '提示文本' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '105fe8a606b74e0ca90ea9ff1d20b648',
              field: 'kh',
              label: '客户',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入客户',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '6833bea0c42c432b83e6946695f2d723',
              field: 'ssgs',
              label: '所属公司',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '24ea4c6631d047a1a8e7c3fe86ab080c',
      label: '表格组件',
      field: 'mesProductionPlanProductList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProductionPlanProductList',
        columns: [
          {
            key: '416cd1b15c314d0dafaf6fc91e3f4653',
            title: '产品选择',
            dataIndex: 'cpid',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              width: '100%',
              span: '',
              placeholder: '请选择产品选择',
              showLabel: true,
              disabled: false,
              datasourceType: 'api',
              labelField: 'label',
              valueField: 'value',
              pageSize: 10,
              assoTitle: '选择产品',
              apiConfig: {
                path: '/scgl/scjh/getAllProduct',
                method: 'GET',
                apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                outputParams: [
                  { name: 'cpmc', tableTitle: '产品名称', show: true, width: 150 },
                  {
                    name: 'cpbh',
                    tableTitle: '物料编号',
                    bindField: 'wuLiaoBianHao8001',
                    show: true,
                    width: 150,
                    component: '1d4bb53150224ab99e0705074b984a4c',
                    bindTable: 'mes_production_plan_product_rela',
                  },
                  {
                    name: 'nbdm',
                    tableTitle: '内部代码',
                    bindField: 'naBuDaiMa1765',
                    show: true,
                    width: 150,
                    component: 'f77bfa3a61294647affb810b83b79d79',
                    bindTable: 'mes_production_plan_product_rela',
                  },
                  {
                    name: 'xh',
                    tableTitle: '型号',
                    bindField: 'xingHao5094',
                    show: true,
                    width: 150,
                    component: 'ebc1972119a6406b90b205247861559c',
                    bindTable: 'mes_production_plan_product_rela',
                  },
                  {
                    name: 'gg',
                    tableTitle: '规格',
                    bindField: 'guiGe（ChiCun）9562',
                    show: true,
                    width: 150,
                    component: '0973f42360874c6e86f425a363afd8ad',
                    bindTable: 'mes_production_plan_product_rela',
                  },
                  {
                    name: 'hjzt',
                    tableTitle: '合金状态',
                    bindField: 'heJinZhuangTai4056',
                    show: true,
                    width: 150,
                    component: 'e466da29e7544bdba302b4829996f478',
                    bindTable: 'mes_production_plan_product_rela',
                  },
                ],
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
            },
          },
          {
            key: '1d4bb53150224ab99e0705074b984a4c',
            title: '物料编号',
            dataIndex: 'wuLiaoBianHao8001',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料编号',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: 'f77bfa3a61294647affb810b83b79d79',
            title: '内部代码',
            dataIndex: 'naBuDaiMa1765',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入内部代码',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: 'ebc1972119a6406b90b205247861559c',
            title: '型号',
            dataIndex: 'xingHao5094',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入型号',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: 'e466da29e7544bdba302b4829996f478',
            title: '合金状态',
            dataIndex: 'heJinZhuangTai4056',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入合金状态',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: '0973f42360874c6e86f425a363afd8ad',
            title: '规格（尺寸）',
            dataIndex: 'guiGe（ChiCun）9562',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入规格（尺寸）',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: '79621370aa1449eda7ccc3d6d710766c',
            title: '数量/件',
            dataIndex: 'sl',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: '9af5e86eea4f4d39b9ad48203e69b92d',
            title: '质量/KG',
            dataIndex: 'zl',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: 0,
              min: 0,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              listStyle: "return 'width:100%'",
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: false,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: false,
        isImport: false,
        isDeleteSelected: false,
        isListView: false,
        viewList: [],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {},
        showPagenation: true,
      },
    },
    {
      key: 'f7ae7fe08ec74cf6b91cd3cd35cfeaaf',
      field: 'zt',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择下拉选择',
        showLabel: true,
        showSearch: false,
        isMultiple: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '1',
        datasourceType: 'dic',
        params: { itemId: '2004464883576217601' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {
          path: 'CodeGeneration/selection',
          method: 'GET',
          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        isShow: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        itemId: '2004464883576217601',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
